/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.AbstractTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingEditor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class SelectAreaTracker
extends AbstractTool {
    protected Rectangle fSelectGroup;
    private Rectangle _visualSelectGroup;
    private Point _visualAnchor;

    public SelectAreaTracker(DrawingEditor editor) {
        super(editor);
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this._visualAnchor = new Point(e.getX(), e.getY());
        this.visualRubberBand(this._visualAnchor.x, this._visualAnchor.y, this._visualAnchor.x, this._visualAnchor.y);
        this.selectionRubberBand(this._anchorX, this._anchorY, this._anchorX, this._anchorY);
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.eraseRubberBand();
        this.visualRubberBand(this._visualAnchor.x, this._visualAnchor.y, e.getX(), e.getY());
        this.selectionRubberBand(this._anchorX, this._anchorY, x, y);
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        super.mouseUp(e, x, y);
        this.eraseRubberBand();
        this.selectGroup(e.isShiftDown());
        this.fSelectGroup = null;
        this._visualSelectGroup = null;
    }

    private void visualRubberBand(int x1, int y1, int x2, int y2) {
        this._visualSelectGroup = new Rectangle(new Point(x1, y1));
        this._visualSelectGroup.add(new Point(x2, y2));
        this.drawXORRect(this._visualSelectGroup);
    }

    private void selectionRubberBand(int x1, int y1, int x2, int y2) {
        this.fSelectGroup = new Rectangle(new Point(x1, y1));
        this.fSelectGroup.add(new Point(x2, y2));
    }

    private void eraseRubberBand() {
        this.drawXORRect(this._visualSelectGroup);
    }

    private void drawXORRect(Rectangle r) {
        Graphics g = this.view().getGraphics();
        this.drawXORRect(r, g);
    }

    private void drawXORRect(Rectangle r, Graphics g) {
        g.setXORMode(this.view().getBackground());
        g.setColor(Color.black);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    protected void selectGroup(boolean toggle) {
        FigureEnumeration k = this.drawing().figuresReverse();
        Vector<Figure> concernedFigures = new Vector<Figure>();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            Rectangle r2 = figure.displayBox();
            if (!this.fSelectGroup.contains(r2.x, r2.y) || !this.fSelectGroup.contains(r2.x + r2.width, r2.y + r2.height)) continue;
            concernedFigures.addElement(figure);
        }
        if (toggle) {
            this.view().toggleSelectionAll(concernedFigures);
        } else {
            this.view().addToSelectionAll(concernedFigures);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this._visualSelectGroup != null) {
            this.drawXORRect(this._visualSelectGroup, g);
        }
    }
}

