/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.framework;

import CH.ifa.draw.io.SimpleFileFilter;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import java.io.File;
import java.util.HashSet;

public class FilterContainer {
    private final ExtensionFileFilter _defaultFileFilter;
    private final HashSet<ExtensionFileFilter> _importfileFilters = new HashSet();
    private final HashSet<ExtensionFileFilter> _exportfileFilters = new HashSet();

    public FilterContainer(ExtensionFileFilter ff) {
        this._defaultFileFilter = ff;
    }

    public FilterContainer(final FileFilter ff) {
        this._defaultFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return ff.accept(f);
            }
        };
        this._defaultFileFilter.setDescription(ff.getDescription());
    }

    public boolean registerImportFileFilter(SimpleFileFilter ff) {
        return this._importfileFilters.add(ff);
    }

    public boolean registerImportFileFilter(final FileFilter ff) {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return ff.accept(f);
            }
        };
        simpleFileFilter.setDescription(ff.getDescription());
        return this._importfileFilters.add(simpleFileFilter);
    }

    public boolean registerExportFileFilter(SimpleFileFilter ff) {
        return this._exportfileFilters.add(ff);
    }

    public boolean registerExportFileFilter(final FileFilter ff) {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return ff.accept(f);
            }
        };
        simpleFileFilter.setDescription(ff.getDescription());
        return this._exportfileFilters.add(simpleFileFilter);
    }

    public boolean deregisterImportFileFilter(SimpleFileFilter ff) {
        return this._importfileFilters.remove(ff);
    }

    public boolean deregisterImportFileFilter(final FileFilter ff) {
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(){

            @Override
            public boolean accept(File f) {
                return ff.accept(f);
            }
        };
        simpleFileFilter.setDescription(ff.getDescription());
        return this._importfileFilters.remove(simpleFileFilter);
    }

    public HashSet<ExtensionFileFilter> getImportFileFilters() {
        return this._importfileFilters;
    }

    public HashSet<ExtensionFileFilter> getExportFileFilters() {
        return this._exportfileFilters;
    }

    public ExtensionFileFilter getDefaultFileFilter() {
        return this._defaultFileFilter;
    }
}

