/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.figures.RamerDouglasPeucker;
import java.awt.Point;
import java.util.Vector;

public class SmoothPolyLineFigure
extends PolyLineFigure {
    private static final long serialVersionUID = -7951352179906577773L;
    private final double _smoothness;

    public SmoothPolyLineFigure(double smoothness) {
        this._smoothness = smoothness;
        this.fPoints = new Vector(4);
    }

    public SmoothPolyLineFigure(int x, int y, double smoothness) {
        this._smoothness = smoothness;
        this.fPoints = new Vector();
        this.fPoints.addElement(new Point(x, y));
    }

    @Override
    public void addPoint(int x, int y) {
        this.fPoints.addElement(new Point(x, y));
        this.fPoints = RamerDouglasPeucker.simplifyTailBySmoothness(this.fPoints, this._smoothness);
        if (this._spline != null) {
            this._spline.setPoints(this.fPoints);
        }
        this.changed();
    }

    @Override
    protected boolean drawAsSpline() {
        return true;
    }

    public PolyLineFigure getEquivalentPolylineFigure() {
        PolyLineFigure figure = new PolyLineFigure();
        figure.setAttribute("LineShape", 1);
        figure.fPoints = this.fPoints;
        return figure;
    }
}

