/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulatorontology.shadow;

import de.renew.simulatorontology.serialisation.SerialisationListener;
import de.renew.simulatorontology.serialisation.SerialisationListenerRegistry;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ShadowNet
implements Serializable {
    private static final long serialVersionUID = 5180248532101141649L;
    private transient Object _context = null;
    private final Set<ShadowNetElement> _elements = new HashSet<ShadowNetElement>();
    private String _name;
    private ShadowNetSystem _netSystem;

    public ShadowNet(String name, ShadowNetSystem netSystem) {
        this._name = name;
        this._netSystem = netSystem;
        netSystem.add(this);
    }

    public ShadowNetSystem getShadowNetSystem() {
        return this._netSystem;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public Set<ShadowNetElement> elements() {
        return Collections.unmodifiableSet(this._elements);
    }

    public void discard() {
        this._netSystem.remove(this);
    }

    public void switchNetSystem(ShadowNetSystem newNetSystem) {
        this._netSystem.remove(this);
        this._netSystem = newNetSystem;
        this._netSystem.add(this);
    }

    void add(ShadowNetElement element) {
        this._elements.add(element);
    }

    void remove(ShadowNetElement element) {
        this._elements.remove(element);
        element.setContext(null);
    }

    public Object getContext() {
        return this._context;
    }

    public void setContext(Object context) {
        this._context = context;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Optional<SerialisationListener<ShadowNet>> listener = SerialisationListenerRegistry.getListener(ShadowNet.class);
        if (listener.isPresent()) {
            listener.get().onRead(this, in);
        }
    }

    private void writeObject(ObjectOutputStream in) throws IOException, ClassNotFoundException {
        in.defaultWriteObject();
        Optional<SerialisationListener<ShadowNet>> listener = SerialisationListenerRegistry.getListener(ShadowNet.class);
        if (listener.isPresent()) {
            listener.get().onWrite(this, in);
        }
    }

    public String toString() {
        return "ShadowNet \"" + this._name + "\" (" + this._elements.size() + " elements)";
    }
}

