/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.expression.VariableExpression;
import de.renew.formalism.base.AbstractSingleNetCompiler;
import de.renew.formalism.java.ArcFactory;
import de.renew.formalism.java.ArcInscription;
import de.renew.formalism.java.ExtendedParseException;
import de.renew.formalism.java.FlexibleInArcFactory;
import de.renew.formalism.java.FlexibleOutArcFactory;
import de.renew.formalism.java.InscriptionParser;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.JavaNetHelper;
import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.PlaceBehaviourModifier;
import de.renew.formalism.java.SimpleArcFactory;
import de.renew.formalism.java.TimedExpression;
import de.renew.formalism.java.Token;
import de.renew.formalism.java.TypedExpression;
import de.renew.net.ExpressionTokenSource;
import de.renew.net.Net;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.Arc;
import de.renew.net.inscription.arc.ClearArc;
import de.renew.net.inscription.transition.ActionInscription;
import de.renew.net.inscription.transition.DownlinkInscription;
import de.renew.net.inscription.transition.ExpressionInscription;
import de.renew.net.inscription.transition.GuardInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.shadowcompiler.SequentialOnlyExtension;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowDeclarationNode;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.unify.Tuple;
import de.renew.util.Types;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class SingleJavaNetCompiler
extends AbstractSingleNetCompiler {
    private boolean allowTimeInscriptions;
    private boolean wantEarlyTokens;
    private transient Hashtable<ShadowPlace, Class<?>> placeTypes = new Hashtable();
    protected ParsedDeclarationNode declaration;

    public SingleJavaNetCompiler(boolean allowDangerousArcs, boolean allowTimeInscriptions, boolean wantEarlyTokens) {
        this.allowTimeInscriptions = allowTimeInscriptions;
        this.wantEarlyTokens = wantEarlyTokens;
    }

    @Override
    public Net createNet(String name) {
        Net net = super.createNet(name);
        net.setEarlyTokens(this.wantEarlyTokens);
        return net;
    }

    protected InscriptionParser makeParser(String inscr) {
        JavaNetParser parser = new JavaNetParser(new StringReader(inscr));
        parser.setNetLoader(this._loopbackNetLoader);
        return parser;
    }

    public static SyntaxException makeSyntaxException(ParseException e) {
        Object o;
        Token t = e.currentToken;
        if (t.next != null) {
            t = t.next;
        }
        if (e instanceof ExtendedParseException && (o = ((ExtendedParseException)e).getProblemSpecificInformation()) != null) {
            return new SyntaxException(e.getMessage(), null, t.beginLine, t.beginColumn, (Throwable)e, o);
        }
        return new SyntaxException(e.getMessage(), null, t.beginLine, t.beginColumn, (Throwable)e);
    }

    public String checkDeclarationNode(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.parseDeclarationNode(inscription);
        return "declaration";
    }

    public String checkArcInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        this.parseArcInscription(inscription);
        return "inscription";
    }

    public String checkTransitionInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        Collection<TransitionInscription> inscriptions = this.makeInscriptions(inscription, null, false);
        if (inscriptions.isEmpty()) {
            return "create";
        }
        TransitionInscription res = inscriptions.iterator().next();
        if (res instanceof ActionInscription) {
            return "action";
        }
        if (res instanceof GuardInscription) {
            return "guard";
        }
        if (res instanceof UplinkInscription) {
            return "uplink";
        }
        if (res instanceof DownlinkInscription) {
            return "downlink";
        }
        if (res instanceof ExpressionInscription) {
            return "expression";
        }
        return null;
    }

    public String checkPlaceInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
        Collection<Object> placeinscriptions = this.parsePlaceInscription(inscription);
        if (placeinscriptions.size() != 1) {
            return null;
        }
        Object element = placeinscriptions.iterator().next();
        if (element instanceof Class) {
            return "placeType";
        }
        if (element instanceof PlaceBehaviourModifier) {
            return "placebehaviour";
        }
        return "initialMarking";
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        int i;
        Vector<Object> parsedInscriptions = new Vector<Object>();
        Vector<ShadowNetElement> errorShadows = new Vector<ShadowNetElement>();
        for (ShadowNetElement elem : shadowPlace.elements()) {
            if (elem instanceof ShadowInscription) {
                String inscr = ((ShadowInscription)elem).getInscription();
                try {
                    Iterator<Object> exprEnum = this.parsePlaceInscription(inscr).iterator();
                    while (exprEnum.hasNext()) {
                        parsedInscriptions.addElement(exprEnum.next());
                        errorShadows.addElement(elem);
                    }
                    continue;
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)elem);
                }
            }
            if (elem instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported place inscription").addObject((Object)shadowPlace).addObject((Object)elem);
        }
        Class type = Types.UNTYPED;
        int typeCount = 0;
        PlaceBehaviourModifier behaviour = new PlaceBehaviourModifier(0);
        int behaviourCount = 0;
        for (i = 0; i < parsedInscriptions.size(); ++i) {
            if (parsedInscriptions.elementAt(i) instanceof Class) {
                type = (Class)parsedInscriptions.elementAt(i);
                ++typeCount;
                continue;
            }
            if (!(parsedInscriptions.elementAt(i) instanceof PlaceBehaviourModifier)) continue;
            behaviour = (PlaceBehaviourModifier)parsedInscriptions.elementAt(i);
            ++behaviourCount;
        }
        if (typeCount > 1) {
            SyntaxException e = new SyntaxException("Place is typed more than once.");
            for (int i2 = 0; i2 < parsedInscriptions.size(); ++i2) {
                if (!(parsedInscriptions.elementAt(i2) instanceof Class)) continue;
                e.addObject(errorShadows.elementAt(i2));
            }
            throw e;
        }
        if (behaviourCount > 1) {
            SyntaxException e = new SyntaxException("Place has more than one assigned behaviour.");
            for (int i3 = 0; i3 < parsedInscriptions.size(); ++i3) {
                if (!(parsedInscriptions.elementAt(i3) instanceof PlaceBehaviourModifier)) continue;
                e.addObject(errorShadows.elementAt(i3));
            }
            throw e;
        }
        if (type != Types.UNTYPED) {
            this.placeTypes.put(shadowPlace, type);
        }
        place.setBehaviour(behaviour._behaviour);
        for (i = 0; i < parsedInscriptions.size(); ++i) {
            if (!(parsedInscriptions.elementAt(i) instanceof TypedExpression)) continue;
            TypedExpression expr = (TypedExpression)parsedInscriptions.elementAt(i);
            Expression castedExpression = null;
            try {
                castedExpression = JavaNetHelper.makeCastedOutputExpression(type, expr);
            }
            catch (SyntaxException e) {
                throw e.addObject(errorShadows.elementAt(i));
            }
            place.add((TokenSource)new ExpressionTokenSource(castedExpression));
        }
    }

    Class<?> getType(ShadowPlace place) {
        if (this.placeTypes.containsKey(place)) {
            return this.placeTypes.get(place);
        }
        return Types.UNTYPED;
    }

    Collection<Object> parsePlaceInscription(String inscr) throws SyntaxException {
        if (inscr != null && !inscr.equals("")) {
            InscriptionParser parser = this.makeParser(inscr);
            parser.setDeclarationNode(this.declaration);
            try {
                return parser.PlaceInscription();
            }
            catch (ParseException e) {
                throw SingleJavaNetCompiler.makeSyntaxException(e);
            }
        }
        return Collections.emptySet();
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        ArcFactory factory = this.getArcFactory(shadowArc);
        if (shadowArc.getShadowArcType() == 5) {
            this.compileClearArc(shadowArc);
        } else {
            this.compileArcInscriptions(shadowArc, factory);
        }
    }

    protected ShadowInscription getSingleArcInscription(ShadowArc arc) throws SyntaxException {
        Set inscriptions = arc.elements();
        if (inscriptions.size() >= 2) {
            SyntaxException e = new SyntaxException("This arc must not be inscribed multiple times.").addObject((Object)arc);
            Iterator iterator = inscriptions.iterator();
            while (iterator.hasNext()) {
                e.addObject(iterator.next());
            }
            throw e;
        }
        if (inscriptions.size() == 1) {
            return (ShadowInscription)inscriptions.iterator().next();
        }
        return null;
    }

    protected TypedExpression parseVariable(String inscr) throws SyntaxException {
        InscriptionParser parser = this.makeParser(inscr);
        parser.setDeclarationNode(this.declaration);
        try {
            return parser.VariableInscription();
        }
        catch (ParseException e) {
            throw SingleJavaNetCompiler.makeSyntaxException(e);
        }
    }

    protected void compileClearArc(ShadowArc shadowArc) throws SyntaxException {
        Transition transition = this.lookup.get(shadowArc.getTransition());
        Place place = this.lookup.get(shadowArc.getPlace());
        Class<?> placeType = this.getType(shadowArc.getPlace());
        ShadowInscription shadowInscription = this.getSingleArcInscription(shadowArc);
        String inscr = null;
        if (shadowInscription != null) {
            inscr = shadowInscription.getInscription();
        }
        if (inscr == null || inscr.equals("")) {
            ClearArc arc = new ClearArc(place, transition, (Expression)new VariableExpression(Types.UNTYPED, null), Object.class);
            arc.setTrace(shadowArc.getTrace());
            transition.add((TransitionInscription)arc);
        } else {
            Class elementType;
            TypedExpression expr;
            try {
                expr = this.parseVariable(inscr);
            }
            catch (SyntaxException e) {
                throw e.addObject((Object)shadowInscription);
            }
            Class<?> exprType = expr.getType();
            if (placeType == Types.UNTYPED) {
                if (exprType != Types.UNTYPED) {
                    throw new SyntaxException("Cannot clear untyped place using typed variable.").addObject((Object)shadowArc);
                }
                elementType = Object.class;
            } else if (exprType == Types.UNTYPED) {
                elementType = placeType;
            } else {
                if (!exprType.isArray()) {
                    throw new SyntaxException("Variable of array type expected.").addObject((Object)shadowInscription);
                }
                elementType = exprType.getComponentType();
                if (!Types.allowsLosslessWidening(placeType, elementType)) {
                    throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(placeType) + " to " + JavaHelper.makeTypeErrorString(elementType) + ".").addObject((Object)shadowInscription);
                }
            }
            ClearArc arc = new ClearArc(place, transition, expr.getExpression(), elementType);
            arc.setTrace(shadowArc.getTrace());
            transition.add((TransitionInscription)arc);
        }
    }

    protected Collection<ArcInscription> makeArcExpressions(String inscription) throws SyntaxException {
        Iterator<ArcInscription> arcInscs = this.parseArcInscription(inscription).iterator();
        ArrayList<ArcInscription> seq = new ArrayList<ArcInscription>();
        while (arcInscs.hasNext()) {
            ArcInscription insc = arcInscs.next();
            if (insc.getExpression().getType() == Void.TYPE) {
                throw new SyntaxException("Cannot use void expressions as arc inscriptions.");
            }
            if (insc.isTimed()) {
                this.setSequential(true);
            }
            seq.add(insc);
        }
        return seq;
    }

    protected Collection<ArcInscription> makeEmptyArcExpressions() throws SyntaxException {
        return this.makeArcExpressions(null);
    }

    protected void compileSingleArcInscription(Collection<ArcInscription> collection, Class<?> placeType, ArcFactory factory, Place place, Transition transition, boolean trace) throws SyntaxException {
        for (ArcInscription insc : collection) {
            if (factory.allowsTime() && this.allowTimeInscriptions) {
                if (insc.isTimed() && insc.getTime().isTyped() && !Types.allowsWideningConversion(insc.getTime().getType(), Double.TYPE)) {
                    throw new SyntaxException("Non-numeric time expression.");
                }
            } else if (insc.isTimed()) {
                if (this.allowTimeInscriptions) {
                    throw new SyntaxException("This arc type does not allow time inscriptions.");
                }
                throw new SyntaxException("Time annotations are not allowed.");
            }
            factory.compileArc(place, transition, trace, placeType, insc);
        }
    }

    protected void compileArcInscriptions(ShadowArc shadowArc, ArcFactory factory) throws SyntaxException {
        Transition transition = this.lookup.get(shadowArc.getTransition());
        Place place = this.lookup.get(shadowArc.getPlace());
        Iterator inscriptions = shadowArc.elements().iterator();
        if (inscriptions.hasNext()) {
            do {
                ShadowInscription inscription = (ShadowInscription)inscriptions.next();
                try {
                    this.compileSingleArcInscription(this.makeArcExpressions(inscription.getInscription()), this.getType(shadowArc.getPlace()), factory, place, transition, shadowArc.getTrace());
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)inscription);
                }
            } while (inscriptions.hasNext());
        } else {
            try {
                factory.emptyArcCheck();
                this.compileSingleArcInscription(this.makeEmptyArcExpressions(), this.getType(shadowArc.getPlace()), factory, place, transition, shadowArc.getTrace());
            }
            catch (SyntaxException e) {
                throw e.addObject((Object)shadowArc);
            }
        }
    }

    protected ArcFactory getArcFactory(Arc.Type arcType, boolean allowTime) {
        return new SimpleArcFactory(arcType, allowTime);
    }

    protected ArcFactory getArcFactory(ShadowArc shadowArc) throws SyntaxException {
        switch (shadowArc.getShadowArcType()) {
            case 0: {
                return this.getArcFactory(Arc.Type.TEST, false);
            }
            case 2: {
                return this.getArcFactory(Arc.Type.BOTH_OT, true);
            }
            case 1: {
                return this.getArcFactory(shadowArc.isPlaceToTransition() ? Arc.Type.IN : Arc.Type.OUT, true);
            }
            case 3: {
                this.setSequential(true);
                return this.getArcFactory(Arc.Type.INHIBITOR, false);
            }
            case 4: {
                if (shadowArc.isPlaceToTransition()) {
                    return FlexibleInArcFactory._instance;
                }
                return FlexibleOutArcFactory._instance;
            }
            case 5: {
                this.setSequential(true);
                return null;
            }
        }
        throw new SyntaxException("Unsupported arc type.").addObject((Object)shadowArc);
    }

    protected Collection<ArcInscription> parseArcInscription(String inscr) throws SyntaxException {
        if (inscr != null && !inscr.equals("")) {
            InscriptionParser parser = this.makeParser(inscr);
            parser.setDeclarationNode(this.declaration);
            try {
                return parser.ArcInscription();
            }
            catch (ParseException e) {
                throw SingleJavaNetCompiler.makeSyntaxException(e);
            }
        }
        return Collections.singleton(new TimedExpression(new TypedExpression(Tuple.class, (Expression)new ConstantExpression(Tuple.class, (Object)new Tuple(0))), null));
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription) throws SyntaxException {
        return this.makeInscriptions(inscription, this.lookup, true);
    }

    protected Collection<TransitionInscription> makeInscriptions(ShadowInscription inscription, ShadowLookup lookup, boolean create) throws SyntaxException {
        String str = inscription.getInscription();
        Transition transition = lookup.get((ShadowTransition)inscription.getInscribable());
        return this.makeInscriptions(str, transition, create);
    }

    protected Collection<TransitionInscription> makeInscriptions(String str, Transition transition, boolean create) throws SyntaxException {
        InscriptionParser parser = this.makeParser(str);
        parser.setLookup(this.lookup);
        parser.setDeclarationNode(this.declaration);
        try {
            return parser.TransitionInscription(create, transition);
        }
        catch (ParseException e) {
            throw SingleJavaNetCompiler.makeSyntaxException(e);
        }
    }

    protected ParsedDeclarationNode compile(ShadowDeclarationNode declaration) throws SyntaxException {
        try {
            return this.parseDeclarationNode(declaration.getInscription());
        }
        catch (SyntaxException e) {
            throw e.addObject((Object)declaration);
        }
    }

    ParsedDeclarationNode parseDeclarationNode(String inscr) throws SyntaxException {
        if (inscr != null) {
            InscriptionParser parser = this.makeParser(inscr);
            try {
                return parser.DeclarationNode();
            }
            catch (ParseException e) {
                throw SingleJavaNetCompiler.makeSyntaxException(e);
            }
        }
        return this.makeEmptyDeclarationNode(null);
    }

    protected ParsedDeclarationNode makeEmptyDeclarationNode(ShadowNet net) {
        return new ParsedDeclarationNode();
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        this.makeDeclarationNode(shadowNet);
    }

    public ParsedDeclarationNode makeDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        ShadowDeclarationNode node = this.findDeclarationNode(shadowNet);
        this.declaration = node == null ? this.makeEmptyDeclarationNode(shadowNet) : this.compile(node);
        return this.declaration;
    }

    private void setSequential(boolean value) {
        SequentialOnlyExtension seqEx = SequentialOnlyExtension.lookup((ShadowLookup)this.lookup);
        seqEx.setSequentialOnly(value);
    }
}

