/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.base;

import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.transition.UplinkInscription;
import de.renew.net.loading.NetLoader;
import de.renew.shadowcompiler.ShadowCompiler;
import de.renew.shadowcompiler.ShadowLookup;
import de.renew.shadowcompiler.ShadowPreprocessor;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowDeclarationNode;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;
import de.renew.simulatorontology.shadow.SyntaxException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class AbstractSingleNetCompiler
implements ShadowCompiler {
    protected ShadowLookup lookup;
    protected NetLoader _loopbackNetLoader;
    protected transient int _placeNum = 0;
    protected transient int transitionNum = 0;

    public void setShadowLookup(ShadowLookup lookup) {
        this.lookup = lookup;
    }

    public ShadowLookup getLookup() {
        return this.lookup;
    }

    public void setLoopbackNetLoader(NetLoader loopbackNetLoader) {
        this._loopbackNetLoader = loopbackNetLoader;
    }

    public Net createNet(String name) {
        return new Net(name);
    }

    public ShadowPreprocessor[] getRequiredPreprocessors() {
        return new ShadowPreprocessor[0];
    }

    protected abstract void compilePlaceInscriptions(ShadowPlace var1, Place var2) throws SyntaxException;

    protected void compile(ShadowPlace shadowPlace, Net net, Serializable groupId) throws SyntaxException {
        Object pname = shadowPlace.getName();
        if (pname == null) {
            ++this._placeNum;
            pname = "P" + this._placeNum;
        }
        Place place = new Place(net, (String)pname, new NetElementID(shadowPlace.getID(), groupId));
        place.setTrace(shadowPlace.getTrace());
        String pcomment = shadowPlace.getComment();
        if (pcomment != null) {
            place.setComment(pcomment);
        }
        this.lookup.set(shadowPlace, place);
        this.compilePlaceInscriptions(shadowPlace, place);
    }

    protected void compile(ShadowPlace shadowPlace, Net net) throws SyntaxException {
        this.compile(shadowPlace, net, NetElementID.DEFAULT_GROUP_ID);
    }

    protected void compile(ShadowTransition shadowTransition, Net net, Serializable groupId) throws SyntaxException {
        int i;
        Object tname = shadowTransition.getName();
        if (tname == null) {
            ++this.transitionNum;
            tname = "T" + this.transitionNum;
        }
        Transition transition = new Transition(net, (String)tname, new NetElementID(shadowTransition.getID(), groupId));
        transition.setTrace(shadowTransition.getTrace());
        String pcomment = shadowTransition.getComment();
        if (pcomment != null) {
            transition.setComment(pcomment);
        }
        this.lookup.set(shadowTransition, transition);
        Vector<TransitionInscription> parsedInscriptions = new Vector<TransitionInscription>();
        Vector<ShadowInscription> errorShadows = new Vector<ShadowInscription>();
        this.compileTransitionInscriptions(shadowTransition, parsedInscriptions, errorShadows);
        int uplinkCount = 0;
        for (i = 0; i < parsedInscriptions.size(); ++i) {
            if (!(parsedInscriptions.elementAt(i) instanceof UplinkInscription)) continue;
            ++uplinkCount;
        }
        if (uplinkCount > 1) {
            SyntaxException e = new SyntaxException("Transition has more than one uplink.");
            for (int i2 = 0; i2 < parsedInscriptions.size(); ++i2) {
                if (!(parsedInscriptions.elementAt(i2) instanceof UplinkInscription)) continue;
                e.addObject((Object)errorShadows.elementAt(i2));
            }
            throw e;
        }
        for (i = 0; i < parsedInscriptions.size(); ++i) {
            transition.add(parsedInscriptions.elementAt(i));
        }
    }

    protected void compile(ShadowTransition shadowTransition, Net net) throws SyntaxException {
        this.compile(shadowTransition, net, NetElementID.DEFAULT_GROUP_ID);
    }

    public void compile(ShadowNet shadowNet) throws SyntaxException {
        Net net = this.lookup.getNet(shadowNet.getName());
        this.parseDeclarations(shadowNet);
        for (Object elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowPlace)) continue;
            this.compile((ShadowPlace)elem, net);
        }
        for (Object elem : shadowNet.elements()) {
            if (!(elem instanceof ShadowTransition)) continue;
            this.compile((ShadowTransition)elem, net);
        }
    }

    protected abstract void compileArc(ShadowArc var1) throws SyntaxException;

    protected abstract Collection<TransitionInscription> compileTransitionInscription(ShadowInscription var1) throws SyntaxException;

    protected void compileNonStandardTransitionInscription(ShadowNetElement elem) throws SyntaxException {
        throw new SyntaxException("Unsupported type of transition inscription").addObject((Object)elem);
    }

    protected void compileTransitionInscriptions(ShadowTransition shadowTransition, Vector<TransitionInscription> parsedInscriptions, Vector<ShadowInscription> errorShadows) throws SyntaxException {
        for (Object elem : shadowTransition.elements()) {
            if (elem instanceof ShadowInscription) {
                Iterator<TransitionInscription> subinscriptions;
                ShadowInscription inscription = (ShadowInscription)elem;
                try {
                    subinscriptions = this.compileTransitionInscription((ShadowInscription)elem).iterator();
                }
                catch (SyntaxException e) {
                    throw e.addObject((Object)inscription);
                }
                while (subinscriptions.hasNext()) {
                    parsedInscriptions.addElement(subinscriptions.next());
                    errorShadows.addElement(inscription);
                }
                continue;
            }
            if (elem instanceof ShadowArc) {
                this.compileArc((ShadowArc)elem);
                continue;
            }
            if (elem instanceof ShadowNetElement) {
                this.compileNonStandardTransitionInscription((ShadowNetElement)elem);
                continue;
            }
            throw new SyntaxException("Unsupported type of transition inscription").addObject(elem);
        }
    }

    public abstract void parseDeclarations(ShadowNet var1) throws SyntaxException;

    protected ShadowDeclarationNode findDeclarationNode(ShadowNet shadowNet) throws SyntaxException {
        Iterator iterator = shadowNet.elements().iterator();
        ShadowDeclarationNode node = null;
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            if (!(elem instanceof ShadowDeclarationNode)) continue;
            if (node != null) {
                SyntaxException e = new SyntaxException("Only one declaration node is allowed.");
                e.addObject((Object)node);
                e.addObject(elem);
                while (iterator.hasNext()) {
                    elem = iterator.next();
                    if (!(elem instanceof ShadowDeclarationNode)) continue;
                    e.addObject(elem);
                }
                throw e;
            }
            node = (ShadowDeclarationNode)elem;
        }
        return node;
    }
}

