/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jline.console.completer.Completer;
import jline.internal.Log;
import jline.internal.Preconditions;

public class RenewArgumentCompleter
implements Completer {
    private final ArgumentDelimiter _delimiter;
    private final List<Completer> _completers = new ArrayList<Completer>();
    private boolean _strict = true;

    public RenewArgumentCompleter(ArgumentDelimiter delimiter, Collection<Completer> completers) {
        this._delimiter = (ArgumentDelimiter)Preconditions.checkNotNull((Object)delimiter);
        Preconditions.checkNotNull(completers);
        this._completers.addAll(completers);
    }

    public RenewArgumentCompleter(ArgumentDelimiter delimiter, Completer ... completers) {
        this(delimiter, Arrays.asList(completers));
    }

    public RenewArgumentCompleter(Completer ... completers) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), completers);
    }

    public RenewArgumentCompleter(List<Completer> completers) {
        this((ArgumentDelimiter)new WhitespaceArgumentDelimiter(), completers);
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public ArgumentDelimiter getDelimiter() {
        return this._delimiter;
    }

    public List<Completer> getCompleters() {
        return this._completers;
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException("Candidates list cannot be null.");
        }
        List<Completer> completers = this.getCompleters();
        if (completers.isEmpty()) {
            return -1;
        }
        ArgumentDelimiter delim = this.getDelimiter();
        ArgumentList list = delim.delimit(buffer, cursor);
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        Completer completer = this.chooseCompleter(argIndex, completers);
        if (this.isStrict() && !this.validatePreviousCompleters(completers, argIndex, list)) {
            return -1;
        }
        int ret = completer.complete(list.getCursorArgument(), argpos, candidates);
        if (ret == -1) {
            return -1;
        }
        int pos = ret + list.getBufferPosition() - argpos;
        this.adjustCandidatesForDelimiters(buffer, cursor, delim, candidates);
        Log.trace((Object[])new Object[]{"Completing ", buffer, " (pos=", cursor, ") with: ", candidates, ": offset=", pos});
        return pos;
    }

    private Completer chooseCompleter(int argIndex, List<Completer> completers) {
        if (argIndex < 0) {
            return completers.get(0);
        }
        if (argIndex >= completers.size()) {
            return completers.get(completers.size() - 1);
        }
        return completers.get(argIndex);
    }

    private boolean validatePreviousCompleters(List<Completer> completers, int argIndex, ArgumentList list) {
        for (int i = 0; i < argIndex; ++i) {
            Completer sub = completers.get(Math.min(i, completers.size() - 1));
            String[] args = list.getArguments();
            String arg = args == null || i >= args.length ? "" : args[i];
            LinkedList subCandidates = new LinkedList();
            if (sub.complete(arg, arg.length(), subCandidates) == -1) {
                return false;
            }
            if (subCandidates.isEmpty()) {
                return false;
            }
            boolean exactMatch = false;
            for (CharSequence candidate : subCandidates) {
                if (!candidate.toString().trim().equals(arg.trim())) continue;
                exactMatch = true;
                break;
            }
            if (exactMatch) continue;
            return false;
        }
        return true;
    }

    private void adjustCandidatesForDelimiters(String buffer, int cursor, ArgumentDelimiter delim, List<CharSequence> candidates) {
        if (buffer != null && cursor != buffer.length() && delim.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                CharSequence val = candidates.get(i);
                while (!val.isEmpty() && delim.isDelimiter(val, val.length() - 1)) {
                    val = val.subSequence(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
    }

    public void addCompleter(Completer completer) {
        this._completers.add(completer);
    }

    public void removeCompleter(Completer completer) {
        this._completers.remove(completer);
    }

    public static interface ArgumentDelimiter {
        public ArgumentList delimit(CharSequence var1, int var2);

        public boolean isDelimiter(CharSequence var1, int var2);
    }

    public static class WhitespaceArgumentDelimiter
    extends AbstractArgumentDelimiter {
        @Override
        public boolean isDelimiterChar(CharSequence buffer, int pos) {
            return Character.isWhitespace(buffer.charAt(pos));
        }
    }

    public static class ArgumentList {
        private String[] _arguments;
        private int _cursorArgumentIndex;
        private int _argumentPosition;
        private int _bufferPosition;

        public ArgumentList(String[] arguments, int cursorArgumentIndex, int argumentPosition, int bufferPosition) {
            this._arguments = (String[])Preconditions.checkNotNull((Object)arguments);
            this._cursorArgumentIndex = cursorArgumentIndex;
            this._argumentPosition = argumentPosition;
            this._bufferPosition = bufferPosition;
        }

        public void setCursorArgumentIndex(int i) {
            this._cursorArgumentIndex = i;
        }

        public int getCursorArgumentIndex() {
            return this._cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this._cursorArgumentIndex < 0 || this._cursorArgumentIndex >= this._arguments.length) {
                return null;
            }
            return this._arguments[this._cursorArgumentIndex];
        }

        public void setArgumentPosition(int pos) {
            this._argumentPosition = pos;
        }

        public int getArgumentPosition() {
            return this._argumentPosition;
        }

        public void setArguments(String[] arguments) {
            this._arguments = arguments;
        }

        public String[] getArguments() {
            return this._arguments;
        }

        public void setBufferPosition(int pos) {
            this._bufferPosition = pos;
        }

        public int getBufferPosition() {
            return this._bufferPosition;
        }
    }

    public static abstract class AbstractArgumentDelimiter
    implements ArgumentDelimiter {
        private char[] _quoteChars = new char[]{'\'', '\"'};
        private char[] _escapeChars = new char[]{'\\'};

        public void setQuoteChars(char[] chars) {
            this._quoteChars = chars;
        }

        public char[] getQuoteChars() {
            return this._quoteChars;
        }

        public void setEscapeChars(char[] chars) {
            this._escapeChars = chars;
        }

        public char[] getEscapeChars() {
            return this._escapeChars;
        }

        @Override
        public ArgumentList delimit(CharSequence buffer, int cursor) {
            LinkedList<String> args = new LinkedList<String>();
            StringBuilder arg = new StringBuilder();
            int argpos = -1;
            int bindex = -1;
            for (int i = 0; buffer != null && i <= buffer.length(); ++i) {
                if (i == cursor) {
                    bindex = args.size();
                    argpos = arg.length();
                }
                if (i == buffer.length() || this.isDelimiter(buffer, i)) {
                    if (arg.isEmpty()) continue;
                    args.add(arg.toString());
                    arg.setLength(0);
                    continue;
                }
                arg.append(buffer.charAt(i));
            }
            return new ArgumentList(args.toArray(new String[args.size()]), bindex, argpos, cursor);
        }

        @Override
        public boolean isDelimiter(CharSequence buffer, int pos) {
            return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
        }

        public boolean isQuoted(CharSequence buffer, int pos) {
            return false;
        }

        public boolean isEscaped(CharSequence buffer, int pos) {
            if (pos <= 0) {
                return false;
            }
            for (int i = 0; this._escapeChars != null && i < this._escapeChars.length; ++i) {
                if (buffer.charAt(pos) != this._escapeChars[i]) continue;
                return !this.isEscaped(buffer, pos - 1);
            }
            return false;
        }

        public abstract boolean isDelimiterChar(CharSequence var1, int var2);
    }
}

