/*
 * Decompiled with CFR 0.152.
 */
package de.renew.console.completer;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import org.apache.log4j.Logger;

public class LocationsCompleter
implements Completer {
    private static final Logger LOGGER = Logger.getLogger(LocationsCompleter.class);

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        return new StringsCompleter(this.getPluginLocations()).complete(buffer, cursor, candidates);
    }

    public ArrayList<String> getPluginLocations() {
        PluginManager pm = PluginManager.getInstance();
        ArrayList<String> locations = new ArrayList<String>();
        for (IPlugin iPlugin : pm.getPlugins()) {
            String pluginName = iPlugin.getName();
            IPlugin plugin = pm.getPluginByName(pluginName);
            if (plugin == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Object)("[" + LocationsCompleter.class.getSimpleName() + "]: Could not find plugin for name: " + pluginName));
                continue;
            }
            locations.add(StringUtil.getExtendedFilename((String)plugin.getProperties().getURL().getFile()));
        }
        return locations;
    }
}

