/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.util.ClassSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MultiPropertyResourceBundle
extends ResourceBundle {
    private final ResourceBundle _bundle;

    public MultiPropertyResourceBundle(ResourceBundle bundle) {
        this._bundle = bundle;
    }

    public MultiPropertyResourceBundle(String baseName) {
        this(baseName, Locale.getDefault());
    }

    public MultiPropertyResourceBundle(String baseName, Locale locale) {
        this(baseName, locale, ClassSource.getClassLoader());
    }

    public MultiPropertyResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        this._bundle = ResourceBundle.getBundle(baseName, locale, loader);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this._bundle.getKeys();
    }

    @Override
    public Locale getLocale() {
        return this._bundle.getLocale();
    }

    @Override
    protected Object handleGetObject(String key) throws MissingResourceException {
        String value = this._bundle.getString(key);
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        String[] strings = new String[tokens.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = ((String)tokens.get(i)).trim();
        }
        return strings;
    }

    @Override
    protected void setParent(ResourceBundle parent) {
        throw new UnsupportedOperationException("Multi property resource bundles do not support parents");
    }
}

