/*
 * Decompiled with CFR 0.152.
 */
package de.renew.propertymanagementgui.gui;

import de.renew.propertymanagementgui.gui.SideNavItemsComponent;
import de.renew.propertymanagementgui.reactivecomponents.Component;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SideNavComponent
extends Component {
    private static final String TITLE = "Plugins";
    private static final int TITLE_FONTSIZE = 13;
    private static final int SIDENAV_WIDTH = 200;
    private static final int TITLE_WRAPPER_HEIGHT = 35;
    private static final EmptyBorder TITLE_WRAPPER_BORDER = new EmptyBorder(10, 10, 10, 10);
    private final Map<String, Runnable> _pluginEntries;

    protected SideNavComponent(Map<String, Runnable> pluginEntries) {
        this._pluginEntries = pluginEntries;
    }

    @Override
    protected JComponent render() {
        JPanel sideNav = new JPanel();
        this.setLayout(sideNav);
        this.setLabelIn(sideNav);
        this.renderSideNavItemsIn(sideNav);
        return sideNav;
    }

    private void setLayout(JComponent sideNav) {
        sideNav.setPreferredSize(new Dimension(200, Integer.MAX_VALUE));
        sideNav.setMaximumSize(new Dimension(200, Integer.MAX_VALUE));
        sideNav.setLayout(new BoxLayout(sideNav, 1));
    }

    private void setLabelIn(JComponent sidenav) {
        JLabel title = new JLabel();
        title.setText(TITLE);
        Font font = title.getFont();
        title.setFont(new Font(font.getName(), font.getStyle(), 13));
        JPanel titleWrapper = new JPanel();
        titleWrapper.setPreferredSize(new Dimension(Integer.MAX_VALUE, 35));
        titleWrapper.setMaximumSize(new Dimension(Integer.MAX_VALUE, titleWrapper.getPreferredSize().height));
        titleWrapper.setBackground(Color.WHITE);
        titleWrapper.setLayout(new BorderLayout());
        titleWrapper.setBorder(TITLE_WRAPPER_BORDER);
        titleWrapper.add((java.awt.Component)title, "West");
        sidenav.add(titleWrapper);
    }

    private void renderSideNavItemsIn(JComponent parentContainer) {
        SideNavItemsComponent sideNavItems = new SideNavItemsComponent(this._pluginEntries);
        parentContainer.add(sideNavItems.get());
    }
}

