/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net.event;

import de.renew.engine.simulator.SimulatorEventQueue;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.event.ListenerSetDispatcher;
import de.renew.net.event.NetEventListener;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListenerSet {
    public static final Logger LOGGER = Logger.getLogger(ListenerSet.class);
    private final transient Set<NetEventListener> _listeners = new HashSet<NetEventListener>();

    synchronized void include(NetEventListener listener) {
        this._listeners.add(listener);
    }

    synchronized void exclude(NetEventListener listener) {
        this._listeners.remove(listener);
    }

    synchronized void dispatch(ListenerSetDispatcher dispatcher) {
        NetEventListener[] listenerArray;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        for (NetEventListener netEventListener : listenerArray = this._listeners.toArray(new NetEventListener[0])) {
            if (netEventListener.wantSynchronousNotification()) {
                try {
                    dispatcher.dispatchTo(netEventListener);
                }
                catch (Error | RuntimeException e) {
                    LOGGER.error((Object)("Error while dispatching net event: " + String.valueOf(e)), e);
                }
                continue;
            }
            NetEventListener listener = netEventListener;
            SimulatorEventQueue.enqueue(() -> {
                assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
                try {
                    dispatcher.dispatchTo(listener);
                }
                catch (Error | RuntimeException e) {
                    LOGGER.error((Object)("Error while dispatching net event: " + String.valueOf(e)), e);
                }
            });
        }
    }
}

