/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.AggregateExpression;
import de.renew.expression.Expression;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.List;

public class ListExpression
extends AggregateExpression {
    private static final int MIN_TAIL_LIST_LENGTH = 2;
    private final boolean _tailed;

    public ListExpression(Expression[] expressions, boolean tailed) {
        super(expressions);
        if (tailed && expressions.length < 2) {
            throw new RuntimeException("Cannot create tailed list with less than two elements.");
        }
        this._tailed = tailed;
    }

    public ListExpression(Expression expr1, Expression expr2) {
        this(new Expression[]{expr1, expr2}, true);
    }

    @Override
    public Class<?> getType() {
        return List.class;
    }

    @Override
    protected Object makeResultAggregate(Object[] args, IStateRecorder recorder) throws Impossible {
        int n = args.length;
        Object result = this._tailed ? args[--n] : List.NULL;
        while (n > 0) {
            result = new List(args[--n], result, recorder);
        }
        return result;
    }
}

