/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.ExpressionWithTypeField;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.ICalculationChecker;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;

public class CallExpression
extends ExpressionWithTypeField {
    private final Expression _argument;
    private final Function _function;

    public CallExpression(Class<?> targetType, Expression argument, Function function) {
        super(targetType);
        this._argument = argument;
        this._function = function;
    }

    @Override
    public boolean isInvertible() {
        return false;
    }

    public Expression getArgument() {
        return this._argument;
    }

    @Override
    public Object startEvaluation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable source = new Variable(this._argument.startEvaluation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        if (checker != null) {
            checker.addEarlyVariable(source, recorder);
        }
        CallExpression.expressionConstraint(target, this._function, source, recorder);
        return target.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper mapper, IStateRecorder recorder, ICalculationChecker checker) throws Impossible {
        Variable source = new Variable(this._argument.registerCalculation(mapper, recorder, checker), recorder);
        Variable target = new Variable();
        checker.addLateVariable(source, recorder);
        checker.addCalculated(this.getType(), target, source.getValue(), recorder);
        return target.getValue();
    }

    public static void expressionConstraint(final Variable target, final Function function, final Variable source, IStateRecorder recorder) throws Impossible {
        Notifiable listener = new Notifiable(){

            @Override
            public void boundNotify(IStateRecorder irecorder) throws Impossible {
                if (Unify.isBound(source)) {
                    Unify.unify(target, function.function(source.getValue()), irecorder);
                }
            }
        };
        source.addListener(listener, recorder);
    }

    public String toString() {
        return "CallExpr(" + Types.typeToString((Class)this.getType()) + ": " + String.valueOf(this._function) + ", " + String.valueOf(this._argument) + ")";
    }
}

