/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.thread;

import de.renew.engine.thread.BlockingSimulationCallable;
import de.renew.engine.thread.BlockingSimulationRunnable;
import de.renew.engine.thread.SimulationThread;
import de.renew.engine.thread.WrappedFutureTask;
import de.renew.util.ClassSource;
import de.renew.util.Semaphor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SimulationThreadPool
extends ThreadPoolExecutor {
    private static final Logger LOGGER = Logger.getLogger(SimulationThreadPool.class);
    private static final Object LOCK = new Object();
    private static SimulationThreadPool _singleton = null;
    private static SimulationThreadPool _newSingleton = null;
    private final SimulatorThreadFactory _factory = (SimulatorThreadFactory)this.getThreadFactory();

    private SimulationThreadPool(int priority) {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SimulatorThreadFactory());
    }

    public void executeAndWait(Runnable task) {
        if (this.isMyThread()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Running simulation runnable directly: " + String.valueOf(task)));
            }
            task.run();
        } else {
            Semaphor semaphore = new Semaphor();
            BlockingSimulationRunnable thread = new BlockingSimulationRunnable(task, semaphore, Thread.currentThread());
            this.execute(thread);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Running simulation runnable indirectly: " + String.valueOf(task)));
            }
            semaphore.P();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Running simulation runnable returned: " + String.valueOf(task)));
        }
    }

    public <T> Future<T> submitAndWait(Callable<T> task) {
        Future<T> returnValue;
        if (this.isMyThread()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Running simulation callable directly:      " + String.valueOf(task) + " in " + String.valueOf(Thread.currentThread())));
            }
            returnValue = new FutureTask<T>(task);
            returnValue.run();
        } else {
            Semaphor semaphore = new Semaphor();
            BlockingSimulationCallable<T> thread = new BlockingSimulationCallable<T>(task, semaphore, Thread.currentThread());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Running simulation callable indirectly:     " + String.valueOf(task) + " in " + String.valueOf(Thread.currentThread())));
            }
            returnValue = this.submit(thread);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("Waiting for simulation callable completion: " + String.valueOf(task) + " in " + String.valueOf(Thread.currentThread())));
            }
            semaphore.P();
        }
        LOGGER.trace((Object)("Running simulation callable returned:       " + String.valueOf(task) + " in " + String.valueOf(Thread.currentThread())));
        return returnValue;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> task) {
        RunnableFuture<T> futureTask;
        if (task instanceof BlockingSimulationCallable) {
            BlockingSimulationCallable blockingTask = (BlockingSimulationCallable)task;
            futureTask = new WrappedFutureTask<T>(blockingTask);
        } else {
            futureTask = super.newTaskFor(task);
        }
        return futureTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getNew() {
        Object object = LOCK;
        synchronized (object) {
            if (_newSingleton == null) {
                _newSingleton = new SimulationThreadPool(5);
            }
            return _newSingleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimulationThreadPool getCurrent() {
        Object object = LOCK;
        synchronized (object) {
            if (_singleton == null) {
                _singleton = new SimulationThreadPool(5);
            }
            return _singleton;
        }
    }

    public static SimulationThreadPool getSimulationThreadPool() {
        return SimulationThreadPool.getCurrent();
    }

    public static boolean isSimulationThread() {
        return _singleton != null && _singleton.isMyThread();
    }

    public boolean isMyThread() {
        return Thread.currentThread().getThreadGroup().equals(this._factory.getThreadGroup());
    }

    public boolean isMyThread(Thread thread) {
        return thread.getThreadGroup().equals(this._factory.getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cleanup() {
        Object object = LOCK;
        synchronized (object) {
            SimulationThreadPool oldSingleton = _singleton;
            _singleton = _newSingleton;
            _newSingleton = null;
            try {
                oldSingleton.shutdownNow();
                return true;
            }
            catch (SecurityException e) {
                LOGGER.error((Object)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discardNew() {
        Object object = LOCK;
        synchronized (object) {
            SimulationThreadPool oldSingleton = _newSingleton;
            _newSingleton = null;
            oldSingleton.shutdown();
        }
    }

    public void setMaxPriority(int priority) {
        this._factory.setMaxPriority(priority);
    }

    public int getMaxPriority() {
        return this._factory.getMaxPriority();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        SimulationThread simulationThread = (SimulationThread)thread;
        if (runnable instanceof BlockingSimulationRunnable) {
            BlockingSimulationRunnable bsr = (BlockingSimulationRunnable)runnable;
            simulationThread.setAncestor(bsr.getAncestor());
        } else if (runnable instanceof WrappedFutureTask) {
            WrappedFutureTask wft = (WrappedFutureTask)runnable;
            simulationThread.setAncestor(wft.getCallable().getAncestor());
        }
    }

    static class SimulatorThreadFactory
    implements ThreadFactory {
        private final ThreadGroup _group;
        private final AtomicInteger _threadNumber = new AtomicInteger(1);
        private final ClassLoader _classLoader;
        private static final String THREAD_GROUP_NAME = "simulation-thread-group";
        private static final String NAME_PREFIX = "simulation-thread-";

        public SimulatorThreadFactory() {
            ThreadGroup top = Thread.currentThread().getThreadGroup();
            while (top.getParent() != null) {
                top = top.getParent();
            }
            this._group = new ThreadGroup(THREAD_GROUP_NAME);
            this._classLoader = ClassSource.getClassLoader();
        }

        @Override
        public Thread newThread(Runnable r) {
            SimulationThread thread = new SimulationThread(this._group, r, NAME_PREFIX + this._threadNumber.getAndIncrement(), 0);
            thread.setContextClassLoader(this._classLoader);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            assert (thread.getThreadGroup().equals(this.getThreadGroup())) : "Thread must belong to thread group of factory";
            return thread;
        }

        public ThreadGroup getThreadGroup() {
            return this._group;
        }

        public void setMaxPriority(int priority) {
            this._group.setMaxPriority(priority);
        }

        public int getMaxPriority() {
            return this._group.getMaxPriority();
        }
    }
}

