/*
 * Decompiled with CFR 0.152.
 */
package de.renew.engine.searcher;

import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.Triggerable;
import de.renew.engine.searcher.TriggerableCollection;
import de.renew.engine.thread.SimulationThreadPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TriggerCollectionImpl
implements Serializable,
TriggerCollection {
    private final Set<TriggerableCollection> _triggers;
    private final Triggerable _triggerable;

    public TriggerCollectionImpl(Triggerable triggerable) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._triggers = new HashSet<TriggerableCollection>();
        this._triggerable = triggerable;
    }

    @Override
    public void include(TriggerableCollection trigger) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._triggers.add(trigger);
    }

    @Override
    public void exclude(TriggerableCollection trigger) {
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        this._triggers.remove(trigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ArrayList<TriggerableCollection> triggers;
        assert (SimulationThreadPool.isSimulationThread()) : "is not in a simulation thread";
        TriggerCollectionImpl triggerCollectionImpl = this;
        synchronized (triggerCollectionImpl) {
            triggers = new ArrayList<TriggerableCollection>(this._triggers);
        }
        triggers.forEach(triggerables -> triggerables.exclude(this._triggerable));
    }
}

