/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database;

import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.NetInstanceEntity;
import de.renew.database.entitylayer.SQLDialect;
import de.renew.database.entitylayer.StateEntity;
import de.renew.database.entitylayer.TokenEntity;
import de.renew.database.entitylayer.TokenPositionEntity;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class SimulationStateDumper {
    private static void dumpTable(Entity entityTemplate) throws SQLException {
        System.out.println(entityTemplate.getTableName() + ":");
        Vector<Entity> entities = Entity.getEntities(entityTemplate);
        Enumeration<Entity> entitiesEnum = entities.elements();
        while (entitiesEnum.hasMoreElements()) {
            Entity entity = entitiesEnum.nextElement();
            System.out.println("   " + entity.toString());
        }
        System.out.println();
    }

    public static void dumpSimulationState(Connection connection, SQLDialect dialect) throws SQLException {
        SimulationStateDumper.dumpTable(new StateEntity(connection, dialect));
        SimulationStateDumper.dumpTable(new NetInstanceEntity(connection, dialect));
        SimulationStateDumper.dumpTable(new TokenEntity(connection, dialect));
        SimulationStateDumper.dumpTable(new TokenPositionEntity(connection, dialect));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 3 || args[0].charAt(0) == '-') {
            System.out.println("SimulationStateDumper.\nDisplays the current simulation state in the database.\nThis includes all nets, places, tokens and token positions.\nParameters: <database url> <database driver class> <database dialect class>\nDatabase dialect may be generic, oracle, msql or mysql.");
            System.exit(0);
        }
        try {
            Class<?> driverClass = Class.forName(args[1]);
            Constructor<?> constructor = driverClass.getConstructor(new Class[0]);
            constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error: Database driver class not found.");
            System.exit(1);
        }
        catch (IllegalAccessException | SecurityException e) {
            System.out.println("Error: Database driver's default constructor is not accessible.");
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error: Database driver's default constructor cannot be invoked.");
            System.exit(1);
        }
        catch (InstantiationException e) {
            System.out.println("Error: Database driver is abstract or an interface.");
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            System.out.println("Error: Database driver's default constructor threw an exception:\n" + String.valueOf(e.getTargetException()));
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error: Database driver has no default constructor.");
            System.exit(1);
        }
        SQLDialect dialect = null;
        try {
            Class<?> dialectClass = Class.forName(args[2]);
            Constructor<?> constructor = dialectClass.getConstructor(new Class[0]);
            dialect = (SQLDialect)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error: SQL dialect class not found.");
            System.exit(1);
        }
        catch (IllegalAccessException | SecurityException e) {
            System.out.println("Error: SQL dialect's default constructor is not accessible.");
            System.exit(1);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error: SQL dialect's default constructor cannot be invoked.");
            System.exit(1);
        }
        catch (InstantiationException e) {
            System.out.println("Error: SQL dialect is abstract or an interface.");
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            System.out.println("Error: SQL dialect's default constructor threw an exception:\n" + String.valueOf(e.getTargetException()));
            System.exit(1);
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error: SQL dialect has no default constructor.");
            System.exit(1);
        }
        Connection connection = null;
        try {
            try {
                connection = DriverManager.getConnection(args[0]);
            }
            catch (SQLException e) {
                System.out.println("Error: Cannot connect to database:\n" + String.valueOf(e));
                System.exit(1);
            }
            try {
                SimulationStateDumper.dumpSimulationState(connection, dialect);
            }
            catch (SQLException e) {
                System.out.println("Error: Exception while dumping:\n" + String.valueOf(e));
                System.exit(1);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

