/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.tool;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.TextHolder;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.ErrorState;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PlaceFigure;
import de.renew.gui.SemanticUpdateFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.shadowcompiler.InscriptionValidator;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import org.apache.log4j.Logger;

public class CPNTextTool
extends ConnectedTextTool {
    private static final Logger logger = Logger.getLogger(CPNTextTool.class);
    private CPNTextFigure fTextFigure = null;
    private CPNDrawing fDrawing = null;

    public CPNTextTool(DrawingEditor editor, CPNTextFigure prototype) {
        super(editor, (TextFigure)prototype);
    }

    public CPNTextTool(DrawingEditor editor, CPNTextFigure prototype, boolean mustConnect) {
        super(editor, (TextFigure)prototype, mustConnect);
    }

    public void beginEdit(TextHolder figure) {
        super.beginEdit(figure);
        if (figure instanceof CPNTextFigure && this.fEditor.drawing() instanceof CPNDrawing) {
            this.fTextFigure = (CPNTextFigure)figure;
            this.fDrawing = (CPNDrawing)this.fEditor.drawing();
        } else {
            this.fTextFigure = null;
        }
    }

    public void endEdit() {
        super.endEdit();
        if (this.fTextFigure != null) {
            String newText;
            boolean special;
            CPNTextFigure textFigure = this.fTextFigure;
            this.fTextFigure = null;
            int type = textFigure.getType();
            boolean bl = special = type == 3;
            if ((type == 1 || special) && !(newText = textFigure.getText()).trim().isEmpty()) {
                try {
                    CPNSimulation sim = ModeReplacement.getInstance().getSimulation();
                    sim.buildAllShadows();
                    ShadowNetSystem netSystem = sim.getNetSystem();
                    ShadowHolder parent = (ShadowHolder)textFigure.parent();
                    ShadowNet shadowNet = this.fDrawing.buildShadow(netSystem);
                    if (textFigure instanceof SemanticUpdateFigure) {
                        ((SemanticUpdateFigure)((Object)textFigure)).semanticUpdate(shadowNet);
                    }
                    if (shadowNet != null) {
                        InscriptionValidator validator = ShadowNetSystemCompiler.getInstance().createInscriptionValidator(shadowNet);
                        if (textFigure instanceof DeclarationFigure) {
                            this.fEditor.showStatus("Checking Declaration Node...");
                            validator.checkDeclarationNode(newText, special);
                        } else if (parent != null && shadowNet != null) {
                            if (parent instanceof TransitionFigure) {
                                this.fEditor.showStatus("Checking Transition Inscription...");
                                validator.checkTransitionInscription(newText, special);
                            } else if (parent instanceof PlaceFigure) {
                                this.fEditor.showStatus("Checking Place Inscription...");
                                validator.checkPlaceInscription(newText, special);
                            } else if (parent instanceof ArcConnection) {
                                this.fEditor.showStatus("Checking Arc Inscription...");
                                validator.checkArcInscription(newText, special);
                            }
                        }
                    }
                    GuiPlugin.getCurrent().closeSyntaxErrorFrame();
                }
                catch (SyntaxException e) {
                    this.fEditor.showStatus("A syntax error occured.");
                    ErrorState fe = FigureExceptionFactory.createFigureException(e);
                    if (fe.getErroneousDrawing().isEmpty()) {
                        fe = FigureExceptionFactory.createFigureException(e, this.fDrawing, textFigure);
                    }
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                    GuiPlugin.getCurrent().processSyntaxException(fe, false);
                }
            }
        }
    }
}

