/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import de.renew.gui.pnml.converter.GraphicConverter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ElementParser;
import java.awt.Color;
import java.awt.Point;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GraphicParser
extends ElementParser {
    private NodeList positions;
    private NodeList dimension;
    private Element offSet;
    private Element fill;
    private Element line;

    private static int parseRoundDouble(String s) {
        return (int)Math.round(Double.parseDouble(s));
    }

    public GraphicParser(Element graphic, NetConverter converter) {
        super(graphic, converter);
    }

    @Override
    protected void doParse() {
        if (this.getElement() != null) {
            this.positions = this.getElement().getElementsByTagName("position");
            this.dimension = this.getElement().getElementsByTagName("dimension");
            NodeList nodeList = this.getElement().getElementsByTagName("offset");
            if (nodeList.getLength() > 0) {
                this.offSet = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("fill")).getLength() > 0) {
                this.fill = (Element)nodeList.item(0);
            }
            if ((nodeList = this.getElement().getElementsByTagName("line")).getLength() > 0) {
                this.line = (Element)nodeList.item(0);
            }
        }
    }

    public Iterator<Point> positions() {
        LinkedList<Point> liste = new LinkedList<Point>();
        if (this.positions != null) {
            for (int pos = 0; pos < this.positions.getLength(); ++pos) {
                Element position = (Element)this.positions.item(pos);
                int x = GraphicParser.parseRoundDouble(position.getAttribute("x"));
                int y = GraphicParser.parseRoundDouble(position.getAttribute("y"));
                liste.add(new Point(x, y));
            }
        }
        return liste.iterator();
    }

    public boolean hasPosition() {
        return this.positions != null && this.positions.getLength() > 0;
    }

    public Point getDimension() {
        if (this.dimension == null || this.dimension.getLength() == 0) {
            return null;
        }
        Point result = new Point();
        Element dim = (Element)this.dimension.item(0);
        result.x = GraphicParser.parseRoundDouble(dim.getAttribute("x"));
        result.y = GraphicParser.parseRoundDouble(dim.getAttribute("y"));
        return result;
    }

    public int offsetX() {
        if (this.offSet == null) {
            return 0;
        }
        return GraphicParser.parseRoundDouble(this.offSet.getAttribute("x"));
    }

    public int offsetY() {
        if (this.offSet == null) {
            return 0;
        }
        return GraphicParser.parseRoundDouble(this.offSet.getAttribute("y"));
    }

    public boolean hasFill() {
        return this.fill != null;
    }

    public Color getFill() {
        if (!this.hasFill()) {
            return null;
        }
        String textColor = this.fill.getAttribute("color");
        return GraphicConverter.instance().parseCSS2Color(textColor);
    }

    public boolean hasLine() {
        return this.line != null;
    }

    public boolean hasLineColor() {
        return this.line != null && !"".equals(this.line.getAttribute("color"));
    }

    public Color getLineColor() {
        if (!this.hasLineColor()) {
            return null;
        }
        String textColor = this.line.getAttribute("color");
        return GraphicConverter.instance().parseCSS2Color(textColor);
    }

    public boolean hasLineStyle() {
        return this.line != null && !"".equals(this.line.getAttribute("style"));
    }

    public String getLineStyle() {
        if (!this.hasLineStyle()) {
            return null;
        }
        String style = this.line.getAttribute("style");
        return GraphicConverter.instance().parsePNMLLineStyle(style);
    }
}

