/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.converter;

import CH.ifa.draw.figures.TextFigure;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.creator.AnnotationCreator;
import de.renew.gui.pnml.creator.AttributeCreator;
import de.renew.gui.pnml.creator.PNMLCreator;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.simulatorontology.shadow.SyntaxException;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public abstract class NetConverterAbstract
implements NetConverter {
    private static final Logger logger = Logger.getLogger(NetConverterAbstract.class);
    private final Converter _converter;
    private final boolean _toolInsc;

    public NetConverterAbstract(Converter converter, boolean toolInsc) {
        this._converter = converter;
        this._toolInsc = toolInsc;
    }

    Converter getConverter() {
        return this._converter;
    }

    @Override
    public boolean isAttribute(Element label) {
        return this.isAttribute(label.getNodeName());
    }

    @Override
    public boolean isAttribute(String tagName) {
        return false;
    }

    @Override
    public boolean isAnnotation(Element label) {
        String tagName = label.getNodeName();
        return tagName.equals("initialMarking") || tagName.equals("name") || tagName.equals("inscription") || tagName.equals("declaration");
    }

    @Override
    public boolean isInRenewAnnotation(Element label) {
        return false;
    }

    @Override
    public TextFigure convertAnnotationToTextFigure(Element label) {
        String tagName = label.getNodeName();
        if (tagName.equals("initialMarking") || tagName.equals("inscription")) {
            return new CPNTextFigure(1);
        }
        if (tagName.equals("name")) {
            return new CPNTextFigure(2);
        }
        if (tagName.equals("declaration")) {
            return new DeclarationFigure();
        }
        return new CPNTextFigure();
    }

    Element generateAnnotationElement(String tagName, CPNTextFigure figure, PNMLCreator pnmlCreator, boolean parentVirtual) {
        if (this.isAttribute(tagName)) {
            AttributeCreator attCreator = new AttributeCreator(pnmlCreator, tagName);
            return attCreator.createElement(figure.getText());
        }
        AnnotationCreator annCreator = new AnnotationCreator(tagName, parentVirtual, this.getConverter());
        return annCreator.createElement(pnmlCreator, figure);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Element annotationToPNML(CPNTextFigure figure, PNMLCreator pnmlCreator, boolean parentVirtual) {
        net = this.getConverter().getShadowNet();
        switch (figure.getType()) {
            case 2: {
                tagName = "name";
                break;
            }
            case 1: {
                parent = figure.parent();
                text = figure.getText();
                if (this._toolInsc) ** GOTO lbl33
                try {
                    validator = ShadowNetSystemCompiler.getInstance().createInscriptionValidator(net);
                    if (figure instanceof DeclarationFigure) {
                        tagName = validator.checkDeclarationNode(text, false);
                    } else if (parent instanceof ArcConnection) {
                        tagName = validator.checkArcInscription(text, false);
                    } else if (parent instanceof PlaceFigure) {
                        tagName = validator.checkPlaceInscription(text, false);
                    } else if (parent instanceof TransitionFigure) {
                        tagName = validator.checkTransitionInscription(text, false);
                    } else {
                        NetConverterAbstract.logger.error((Object)(NetConverterAbstract.class.getSimpleName() + ": inscribed net element figure's class is not recognized: " + parent.getClass().getSimpleName()));
                        tagName = null;
                    }
                    if (tagName != null) break;
                    NetConverterAbstract.logger.error((Object)(NetConverterAbstract.class.getSimpleName() + ": could not find PNML element name for inscription: " + text));
                }
                catch (SyntaxException e) {
                    NetConverterAbstract.logger.error((Object)(NetConverterAbstract.class.getSimpleName() + ": " + e.getMessage() + "\nIt seems that the net " + net.getName() + " contains a syntax error.\nPlease, fix before exporting."));
                    if (!NetConverterAbstract.logger.isDebugEnabled()) ** GOTO lbl33
                    NetConverterAbstract.logger.debug((Object)(NetConverterAbstract.class.getSimpleName() + ": " + String.valueOf((Object)e)));
                }
lbl33:
                // 4 sources

                tagName = figure instanceof DeclarationFigure != false ? "declaration" : "inscription";
                toolSpec = pnmlCreator.createToolspecific();
                toolSpec.appendChild(this.generateAnnotationElement(tagName, figure, pnmlCreator, parentVirtual));
                return toolSpec;
            }
            case 0: {
                tagName = "label";
                break;
            }
            default: {
                throw new RuntimeException("Unkown type " + figure.getType());
            }
        }
        return this.generateAnnotationElement(tagName, figure, pnmlCreator, parentVirtual);
    }

    @Override
    public String convertAttributeNameToRenewName(Element attribute) {
        String parent = attribute.getParentNode().getNodeName();
        String type = attribute.getNodeName();
        if ("arc".equals(parent) && "type".equals(type)) {
            return "ArcType";
        }
        return type;
    }

    public static boolean isNetParser(String netType) {
        return false;
    }
}

