/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.menu;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.ui.api.CommandApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.SelectionMode;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.InscribableFigure;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class EditMenuExtender {
    public Collection<JMenuItem> createMenus() {
        ArrayList<JMenuItem> result = new ArrayList<JMenuItem>();
        JMenu selectMenu = this.createSelectMenu(SelectionMode.SELECT);
        result.add(selectMenu);
        JMenu addSelectMenu = this.createSelectMenu(SelectionMode.ADD);
        result.add(addSelectMenu);
        JMenu removeSelectMenu = this.createSelectMenu(SelectionMode.REMOVE);
        result.add(removeSelectMenu);
        JMenu restrictSelectMenu = this.createSelectMenu(SelectionMode.RESTRICT);
        result.add(restrictSelectMenu);
        return result;
    }

    protected JMenu createSelectMenu(SelectionMode selectMode) {
        String selectMenuTitle = switch (selectMode) {
            default -> throw new IncompatibleClassChangeError();
            case SelectionMode.SELECT -> "Select";
            case SelectionMode.ADD -> "Add To Selection";
            case SelectionMode.REMOVE -> "Remove From Selection";
            case SelectionMode.RESTRICT -> "Restrict Selection";
        };
        CommandMenu selectMenu = DrawApplication.createCommandMenu((String)selectMenuTitle);
        CommandMenu nodeMenu = DrawApplication.createCommandMenu((String)"Nodes");
        nodeMenu.add(CommandApi.createSelectCommand((String)"All", NodeFigure.class, (SelectionMode)selectMode));
        nodeMenu.add(CommandApi.createSelectCommand((String)"Transitions", TransitionFigure.class, (SelectionMode)selectMode));
        nodeMenu.add(CommandApi.createSelectCommand((String)"Places", PlaceFigure.class, (SelectionMode)selectMode));
        selectMenu.add((JMenuItem)nodeMenu);
        selectMenu.add(CommandApi.createSelectCommand((String)"Arcs", ArcConnection.class, (SelectionMode)selectMode));
        selectMenu.add(CommandApi.createSelectCommand((String)"Nodes and Arcs", InscribableFigure.class, (SelectionMode)selectMode));
        CommandMenu textChildMenu = DrawApplication.createCommandMenu((String)"Text Children");
        textChildMenu.add(CommandApi.createSelectCommand((String)"All", CPNTextFigure.class, InscribableFigure.class, (SelectionMode)selectMode));
        textChildMenu.add(CommandApi.createSelectCommand((String)"of Transitions", CPNTextFigure.class, TransitionFigure.class, (SelectionMode)selectMode));
        textChildMenu.add(CommandApi.createSelectCommand((String)"of Places", CPNTextFigure.class, PlaceFigure.class, (SelectionMode)selectMode));
        textChildMenu.add(CommandApi.createSelectCommand((String)"of Arcs", CPNTextFigure.class, ArcConnection.class, (SelectionMode)selectMode));
        selectMenu.add((JMenuItem)textChildMenu);
        CommandMenu inscrMenu = DrawApplication.createCommandMenu((String)"Inscriptions");
        inscrMenu.add(EditMenuExtender.createSelectCommand("All", InscribableFigure.class, 1, selectMode));
        inscrMenu.add(EditMenuExtender.createSelectCommand("of Transitions", TransitionFigure.class, 1, selectMode));
        inscrMenu.add(EditMenuExtender.createSelectCommand("of Places", PlaceFigure.class, 1, selectMode));
        inscrMenu.add(EditMenuExtender.createSelectCommand("of Arcs", ArcConnection.class, 1, selectMode));
        selectMenu.add((JMenuItem)inscrMenu);
        CommandMenu nameMenu = DrawApplication.createCommandMenu((String)"Names");
        nameMenu.add(EditMenuExtender.createSelectCommand("All", InscribableFigure.class, 2, selectMode));
        nameMenu.add(EditMenuExtender.createSelectCommand("of Transitions", TransitionFigure.class, 2, selectMode));
        nameMenu.add(EditMenuExtender.createSelectCommand("of Places", PlaceFigure.class, 2, selectMode));
        selectMenu.add((JMenuItem)nameMenu);
        return selectMenu;
    }

    protected static AbstractCommand createSelectCommand(String title, Class<?> parentClass, int type, SelectionMode selectMode) {
        return CommandApi.createSelectCommand((String)title, fig -> fig instanceof CPNTextFigure && parentClass.isInstance(((ChildFigure)fig).parent()) && ((CPNTextFigure)fig).getType() == type, (SelectionMode)selectMode);
    }
}

