/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.application.SimulatorPlugin;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceList;
import de.renew.plugin.PluginManager;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.RemotePlugin;
import de.renew.remote.RemoteServerRegistry;
import de.renew.simulator.api.SimulationManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

class RemoteServerWindow
extends JFrame {
    private static final Logger logger = Logger.getLogger(RemoteServerWindow.class);
    private JComboBox<Object> _servers;
    private JList<Object> _instancesList;
    protected JButton _openButton;
    protected JButton _disconnectButton;
    private final ConnectDialog _dialog;

    RemoteServerWindow() {
        super("Remote Renew Servers");
        this.initGui();
        this._dialog = new ConnectDialog(this);
    }

    private void initGui() {
        this.setDefaultCloseOperation(2);
        Container root = this.getContentPane();
        root.setLayout(new GridBagLayout());
        this._servers = new JComboBox();
        this._servers.setEditable(false);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 1, 1);
        root.add(this._servers, gbc);
        JButton connect = new JButton("Connect...");
        connect.addActionListener(e -> this._dialog.setVisible(true));
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 1, 1);
        root.add((Component)connect, gbc);
        this._disconnectButton = new JButton("Disconnect");
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 1, 1);
        root.add((Component)this._disconnectButton, gbc);
        this._instancesList = new JList();
        this._instancesList.setSelectionMode(0);
        this._instancesList.addListSelectionListener(e -> this._openButton.setEnabled(!this._instancesList.isSelectionEmpty()));
        this._instancesList.setCellRenderer(new MyCellRenderer());
        JScrollPane scroll = new JScrollPane(this._instancesList);
        scroll.setVerticalScrollBarPolicy(22);
        gbc = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 5), 1, 1);
        root.add((Component)scroll, gbc);
        this._openButton = new JButton("Open net");
        this._openButton.setEnabled(false);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 1, 1);
        root.add((Component)this._openButton, gbc);
        JButton close = new JButton("Close");
        close.addActionListener(e -> this.dispose());
        gbc = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 1, 1);
        root.add((Component)close, gbc);
        this.pack();
    }

    void addServerSelectedListener(ActionListener listener) {
        this._servers.addActionListener(listener);
    }

    void addDisconnectListener(ActionListener listener) {
        this._disconnectButton.addActionListener(listener);
    }

    void addConnectListener(ActionListener listener) {
        this._dialog._connectButton.addActionListener(listener);
    }

    void addOpenNetInstanceListener(final Runnable listener) {
        this._instancesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    listener.run();
                }
            }
        });
        this._openButton.addActionListener(e -> listener.run());
    }

    public void updateView() throws RemoteException {
        int index = this._servers.getSelectedIndex();
        RemoteServerRegistry.ServerDescriptor[] servers = RemoteServerRegistry.instance().allServers();
        Vector<String> v = new Vector<String>(servers.length + 1);
        v.add("local nets");
        v.addAll(Arrays.asList(servers));
        this._servers.setModel(new DefaultComboBoxModel(v));
        if (index < 0 && !v.isEmpty()) {
            index = 0;
        } else if (index >= v.size()) {
            index = v.size() - 1;
        }
        this._servers.setSelectedIndex(index);
        this._disconnectButton.setEnabled(servers.length != 0 && this._servers.getSelectedIndex() > 0);
        SimulatorPlugin simulatorPlugin = (SimulatorPlugin)PluginManager.getInstance().getPluginByName("Renew Simulator");
        if (index > 0) {
            NetInstanceAccessor[] nets = RemoteServerRegistry.instance().allNetInstances(index - 1);
            Arrays.sort(nets, (b1, b2) -> {
                try {
                    int number1 = Integer.parseInt(b1.getID());
                    int number2 = Integer.parseInt(b2.getID());
                    return Integer.compare(number1, number2);
                }
                catch (RemoteException e) {
                    logger.error((Object)"Exception while sorting nets", (Throwable)e);
                    return 0;
                }
            });
            this._instancesList.setListData((Object[])nets);
        } else if (index == 0 && SimulationManager.isSimulationActive()) {
            NetInstance[] nets = NetInstanceList.getAll();
            WeakNetInstanceWrapper[] weakNets = new WeakNetInstanceWrapper[nets.length];
            RemotePlugin remote = RemotePlugin.getInstance();
            for (int i = 0; i < nets.length; ++i) {
                weakNets[i] = new WeakNetInstanceWrapper(remote.wrapInstance(nets[i]));
            }
            Arrays.sort(weakNets, (b1, b2) -> {
                try {
                    int number1 = Integer.parseInt(b1.getInstance().getID());
                    int number2 = Integer.parseInt(b2.getInstance().getID());
                    return Integer.compare(number1, number2);
                }
                catch (RemoteException e) {
                    logger.error((Object)"Exception while sorting nets", (Throwable)e);
                    return 0;
                }
            });
            this._instancesList.setListData((Object[])weakNets);
        } else {
            this._instancesList.setListData((Object[])new Object[0]);
        }
    }

    String getDialogName() {
        return this._dialog._name.getText();
    }

    String getDialogServer() {
        return this._dialog._server.getText();
    }

    void disposeDialog() {
        this._dialog.dispose();
    }

    void selectServer(RemoteServerRegistry.ServerDescriptor server) {
        this._servers.setSelectedItem(server);
    }

    int getSelectedServerIndex() {
        return this._servers.getSelectedIndex();
    }

    int getSelectedNetInstanceIndex() {
        return this._instancesList.getSelectedIndex();
    }

    Object getNetInstanceModelByIndex(int index) {
        return this._instancesList.getModel().getElementAt(index);
    }

    class ConnectDialog
    extends JDialog {
        protected JTextField _server;
        protected JTextField _name;
        private JButton _connectButton;

        ConnectDialog(JFrame parent) {
            super(parent, "Connect to remote Renew server...", true);
            this.initConnectDialog();
        }

        private void initConnectDialog() {
            this.setDefaultCloseOperation(2);
            Container root = this.getContentPane();
            root.setLayout(new GridBagLayout());
            JLabel l = new JLabel("Server ");
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(10, 10, 0, 5), 1, 1);
            root.add((Component)l, gbc);
            this._server = new JTextField("localhost", 20);
            gbc = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 10), 1, 1);
            root.add((Component)this._server, gbc);
            l = new JLabel("Name ");
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 10, 0, 5), 1, 1);
            root.add((Component)l, gbc);
            this._name = new JTextField("default", 20);
            gbc = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 10), 1, 1);
            root.add((Component)this._name, gbc);
            this._connectButton = new JButton("Connect");
            gbc = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 12, 0, new Insets(5, 5, 10, 5), 1, 1);
            root.add((Component)this._connectButton, gbc);
            this.getRootPane().setDefaultButton(this._connectButton);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(e -> this.dispose());
            gbc = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 10, 10), 1, 1);
            root.add((Component)cancel, gbc);
            this.pack();
        }
    }

    static class MyCellRenderer
    extends DefaultListCellRenderer {
        MyCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof NetInstanceAccessor) {
                NetInstanceAccessor accessor = (NetInstanceAccessor)value;
                try {
                    String str = accessor.asString();
                    this.setText(str);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return this;
        }
    }

    static class WeakNetInstanceWrapper {
        final WeakReference<NetInstanceAccessor> instance;
        String description;

        WeakNetInstanceWrapper(NetInstanceAccessor net) {
            this.instance = new WeakReference<NetInstanceAccessor>(net);
            try {
                this.description = net.asString();
            }
            catch (RemoteException e) {
                this.description = e.toString();
            }
        }

        NetInstanceAccessor getInstance() {
            return (NetInstanceAccessor)this.instance.get();
        }

        public String toString() {
            return this.description;
        }
    }
}

