/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.gui.CPNDrawing;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowNetSystemCompiler;
import de.renew.shadowcompiler.ShadowNetSystemCreator;
import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class ShadowTranslator {
    private static final Logger logger = Logger.getLogger(ShadowTranslator.class);
    private static final StatusDisplayer sd = string -> System.err.println(string);

    public static void main(String[] args) {
        System.setProperty("de.renew.noGraphics", "true");
        Logger rootLogger = Logger.getRootLogger();
        ConsoleAppender appender = new ConsoleAppender((Layout)new SimpleLayout(), "System.out");
        rootLogger.addAppender((Appender)appender);
        rootLogger.setLevel(Level.DEBUG);
        if (args.length == 0) {
            logger.error((Object)"Usage: java de.renew.gui.ShadowTranslator file.rnw ...");
            logger.info((Object)"Converts Renew drawings (.rnw) to shadow nets (.sns).");
            logger.info((Object)"No syntax check or compilation is done, just conversion.");
            System.exit(1);
        }
        ExtensionFileFilter ff = FileFilterCreator.createRNWFileFilter();
        ArrayList<File> names = new ArrayList<File>(args.length);
        for (String arg : args) {
            names.add(DrawingFileHelper.checkAndAddExtension((File)new File(arg), (ExtensionFileFilter)ff));
        }
        CPNDrawing[] drawings = ShadowTranslator.readDrawings(names.toArray(new File[0]));
        ShadowTranslator.writeShadows(drawings);
        System.exit(0);
    }

    public static CPNDrawing[] readDrawings(File[] files) {
        ArrayList<CPNDrawing> drawings = new ArrayList<CPNDrawing>(files.length);
        for (File file : files) {
            try {
                Drawing drawing = DrawingFileHelper.loadDrawing((File)file, (StatusDisplayer)sd);
                if (drawing == null) continue;
                if (drawing instanceof CPNDrawing) {
                    CPNDrawing cpnDrawing = (CPNDrawing)drawing;
                    drawings.add(cpnDrawing);
                    continue;
                }
                logger.warn((Object)(drawing.getName() + " is not a CPN drawing - ignored."));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return drawings.toArray(new CPNDrawing[0]);
    }

    public static void writeShadows(CPNDrawing[] drawings) {
        try {
            ShadowTranslator.writeShadows(null, false, drawings);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public static void writeShadows(ShadowCompilerFactory compilerFactory, boolean compile, CPNDrawing[] drawings) throws SyntaxException {
        ShadowTranslator.writeShadows(compilerFactory, compile, drawings, null);
    }

    public static void writeShadows(ShadowCompilerFactory compilerFactory, boolean compile, CPNDrawing[] drawings, File[] destsnsfiles) throws SyntaxException {
        ShadowTranslator.writeShadows(compilerFactory, compile, drawings, destsnsfiles, null);
    }

    public static void writeShadows(ShadowCompilerFactory compilerFactory, boolean compile, CPNDrawing[] drawings, File[] destsnsfiles, ShadowNetLoader netloader) throws SyntaxException {
        if (compile) {
            ShadowTranslator.createGlobalSns(compilerFactory, compile, drawings, netloader);
        }
        int count = 0;
        for (int i = 0; i < drawings.length; ++i) {
            File path;
            CPNDrawing currentDrawing = drawings[i];
            ShadowNetSystem netSystem = ShadowNetSystemCreator.createWithCompiler((ShadowCompilerFactory)compilerFactory);
            currentDrawing.buildShadow(netSystem);
            String name = currentDrawing.getName();
            if (destsnsfiles != null) {
                path = destsnsfiles[i];
            } else {
                path = currentDrawing.getFilename();
                if (path != null) {
                    try {
                        path = path.getCanonicalFile();
                        path = new File(path.getParent(), name + ".sns");
                    }
                    catch (IOException e) {
                        logger.error((Object)("Cannot compute sns filename for net " + name + "."), (Throwable)e);
                        path = null;
                    }
                }
            }
            if (path == null) {
                logger.warn((Object)("Skipping net " + name + " (no filename)."));
            } else {
                try {
                    logger.debug((Object)("Exporting net " + name + " to " + String.valueOf(path) + "..."));
                    FileOutputStream stream = new FileOutputStream(path);
                    ObjectOutputStream output = new ObjectOutputStream(stream);
                    output.writeObject(netSystem);
                    output.close();
                    ++count;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            currentDrawing.discardShadow();
        }
        logger.info((Object)("Exported " + count + " shadow net" + (count == 1 ? "" : "s") + "."));
    }

    private static ShadowNetSystem createGlobalSns(ShadowCompilerFactory compilerFactory, boolean compile, CPNDrawing[] drawings, ShadowNetLoader netloader) throws SyntaxException {
        logger.debug((Object)("Creating shadow net system with compiler " + String.valueOf(compilerFactory) + " and net loader " + String.valueOf(netloader) + "."));
        ShadowNetSystem netSystem = ShadowNetSystemCreator.createWithCompiler((ShadowNetLoader)netloader, (ShadowCompilerFactory)compilerFactory);
        for (CPNDrawing currentDrawing : drawings) {
            currentDrawing.buildShadow(netSystem);
        }
        if (compile) {
            ShadowNetSystemCompiler.getInstance().compile(netSystem);
        }
        return netSystem;
    }

    public static void writeSingleShadow(CPNDrawing[] drawings, File fileName) {
        try {
            ShadowTranslator.writeSingleShadow(null, false, drawings, fileName);
        }
        catch (SyntaxException syntaxException) {
            // empty catch block
        }
    }

    public static void writeSingleShadow(ShadowCompilerFactory compilerFactory, boolean compile, CPNDrawing[] drawings, File fileName) throws SyntaxException {
        ShadowNetSystem netSystem = ShadowTranslator.createGlobalSns(compilerFactory, compile, drawings, null);
        if (fileName == null) {
            logger.error((Object)"Cannot write output sns, no filename given.");
        } else {
            try {
                logger.debug((Object)("Exporting all nets to " + String.valueOf(fileName) + "..."));
                FileOutputStream stream = new FileOutputStream(fileName);
                ObjectOutputStream output = new ObjectOutputStream(stream);
                output.writeObject(netSystem);
                output.close();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        logger.info((Object)("Exported " + drawings.length + " shadow net" + (drawings.length == 1 ? "" : "s") + "."));
    }
}

