/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.standard.StandardDrawingEditor;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.Tool;
import de.renew.engine.searchqueue.SearchQueue;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNDrawingEditor;
import de.renew.gui.CPNDrawingView;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PaletteHolder;
import de.renew.gui.TokenBagDrawing;
import de.renew.gui.tool.CPNSelectionTool;
import de.renew.io.FileFilterCreator;
import de.renew.plugin.PluginManager;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.windowmanagement.Workbench;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CPNApplication
extends DrawApplication {
    private static final Logger logger = Logger.getLogger(CPNApplication.class);
    public static final String CPNIMAGES = "/de/renew/gui/images/";
    private final CPNDrawingEditor fDelegateEditor;
    private GuiPlugin fPlugin;

    protected CPNApplication(String[] args, GuiPlugin plugin, Workbench workbench, CPNDrawingEditor editor) {
        super("Reference Net Workshop", "de.renew.gui.CPNDrawing", FileFilterCreator.createRNWFileFilter(), args, "/de/renew/gui/images/RENEW.gif", workbench, (StandardDrawingEditor)editor);
        this.fDelegateEditor = editor;
        this.fPlugin = plugin;
        if (this.fPlugin != null) {
            this.fPlugin.notifyGuiStart(this);
        }
    }

    public ShadowCompilerFactory getDefaultCompilerFactory() {
        return ModeReplacement.getInstance().getDefaultCompilerFactory();
    }

    protected Drawing createDrawing() {
        return new CPNDrawing();
    }

    void cleanupSimulationWindows() {
        this.showStatus("Simulation terminated.");
        BindingSelectionFrame.close();
        this.closeAllSimulationDrawings();
    }

    void closeAllSimulationDrawings() {
        boolean goon;
        block0: do {
            goon = false;
            Enumeration drawenumeration = this.fDelegateEditor.getDrawingLookup().getAllDrawings();
            while (drawenumeration.hasMoreElements()) {
                Drawing drawing = (Drawing)drawenumeration.nextElement();
                if (!(drawing instanceof CPNInstanceDrawing) && !(drawing instanceof TokenBagDrawing)) continue;
                this.closeDrawing(drawing);
                goon = true;
                continue block0;
            }
        } while (goon);
    }

    public void openNetPatternDrawing(String netName) {
        this.openNetPatternDrawing(netName, 0);
    }

    public void openNetPatternDrawing(String netName, int elementID) {
        this.fDelegateEditor.showNetPatternDrawing(netName, elementID);
    }

    protected StandardDrawingView createDrawingView(int width, int height) {
        return new CPNDrawingView((DrawingEditor)this, width, height);
    }

    protected Component wrapStatusLine(Component statusLine) {
        boolean showClock = ModeReplacement.getInstance().getSimulation().isStrictlySequential();
        if (showClock) {
            JPanel panel = new JPanel();
            GridBagLayout layout = new GridBagLayout();
            panel.setLayout(layout);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.weightx = 1.0;
            layout.setConstraints(statusLine, constraints);
            panel.add(statusLine);
            if (statusLine instanceof JTextField) {
                JTextField textStatusLine = (JTextField)statusLine;
                textStatusLine.setColumns(textStatusLine.getColumns() - 23);
            }
            JTextField clock = new JTextField("0.0", 23);
            SearchQueue.insertTimeListener(() -> EventQueue.invokeLater(() -> clock.setText(String.valueOf(SearchQueue.getTime()))));
            clock.setEditable(false);
            constraints.weightx = 0.0;
            layout.setConstraints(clock, constraints);
            panel.add(clock);
            return panel;
        }
        return statusLine;
    }

    boolean syntaxCheck() {
        if (ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            this.showStatus("Terminate the current simulation before a syntax check.");
        } else {
            try {
                ModeReplacement.getInstance().getSimulation().syntaxCheckOnly();
                this.showStatus("Syntax check successful.");
                GuiPlugin.getCurrent().closeSyntaxErrorFrame();
                return true;
            }
            catch (SyntaxException e) {
                logger.debug((Object)e.getMessage(), (Throwable)e);
                GuiPlugin.getCurrent().processSyntaxException(FigureExceptionFactory.createFigureException(e), true);
            }
        }
        return false;
    }

    public JFrame getFrame() {
        return super.getFrame();
    }

    public void openInstanceDrawing(NetInstanceAccessor instance) {
        assert (EventQueue.isDispatchThread()) : "Must be called within AWT event thread.";
        try {
            InstanceDrawing instDraw = CPNInstanceDrawing.getInstanceDrawing(instance);
            if (instDraw != null) {
                this.fDelegateEditor.openDrawing(instDraw);
            }
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
        }
    }

    public void openTokenBagDrawing(PlaceInstanceAccessor pi) throws RemoteException {
        TokenBagDrawing tokenDraw = TokenBagDrawing.getTokenBagDrawing(pi);
        InstanceDrawing instDraw = CPNInstanceDrawing.getInstanceDrawing(pi.getNetInstance());
        this.fDelegateEditor.openTokenBagDrawing(tokenDraw, instDraw);
    }

    public void requestClose() {
        boolean shutdownPluginSystem = false;
        if (this.fPlugin != null) {
            shutdownPluginSystem = this.fPlugin.isShutdownOnClose();
        }
        if (shutdownPluginSystem) {
            this.showStatus("Shutting down plugin system...");
            this.fPlugin.doShutdownOnClose();
        } else {
            this.showStatus("Closing Renew Gui...");
            super.requestClose();
        }
    }

    public void exit() {
        BindingSelectionFrame.close();
        this.closeAllSimulationDrawings();
        super.exit();
        this.destroy();
    }

    protected void destroy() {
        if (this.fPlugin != null) {
            this.fPlugin.notifyGuiClosed(this);
            this.fPlugin = null;
        }
    }

    public boolean canClose() {
        if (!PluginManager.getInstance().isStopping() && ModeReplacement.getInstance().getSimulation().isSimulationActive()) {
            int answer = JOptionPane.showConfirmDialog(null, "Renew: The simulation engine is still active.\nIt can continue running without graphical feedback.\n Do you want to terminate it now?");
            switch (answer) {
                case 0: {
                    ModeReplacement.getInstance().getSimulation().simulationTerminate();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return false;
                }
            }
        }
        return super.canClose();
    }

    public ToolButton toolButtonForTextFigure(TextFigure figure) {
        PaletteHolder paletteHolder = this.fPlugin.getPaletteHolder();
        ToolButton toolButton = paletteHolder.getTextFigureToolButtonRegistry().toolButtonForTextFigure(figure);
        if (toolButton != null) {
            return toolButton;
        }
        return this.fDelegateEditor.toolButtonForTextFigure(figure);
    }

    protected Tool createSelectionTool() {
        return new CPNSelectionTool((DrawingEditor)this);
    }

    public void recheckMenus() {
        this.menuStateChanged();
    }

    public static void main(String[] args) {
        System.out.println("The CPNApplication class does no longer provide a stand-alone application.");
        System.out.println("Please run de.renew.plugin.PluginManager with the command \"gui\".");
        System.out.println("A simple command line is:");
        System.out.println("       java -jar loader.jar gui [filenames]");
    }
}

