/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class Loader {
    private static final String JAVA_PATH = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private static final String DIR_COMMONLIBS = "libs";
    private static final String JARFILE_LOADER = "de.renew.loader.jar";
    private static List<String> renewArgs;

    public static void main(String[] args) {
        if ("Mac OS X".equals(System.getProperty("os.name"))) {
            System.setProperty("com.apple.macos.useScreenMenubar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Renew");
            System.setProperty("apple.awt.application.name", "Renew");
        }
        renewArgs = Arrays.asList(args);
        try {
            URL url = Loader.class.getProtectionDomain().getCodeSource().getLocation();
            String base = url.toExternalForm();
            base = base.substring(0, base.lastIndexOf("/"));
            url = new URL(base + "/");
            Loader.loadRenew(url, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ClassLoader loadRenewAndReturnClassLoader(URL baseURL, String[] args) throws MalformedURLException {
        return null;
    }

    private static Collection<URL> classPathURLs() {
        ArrayList<URL> cpURLs = new ArrayList<URL>();
        String cp = System.getProperty("java.class.path");
        if (cp != null) {
            String[] cpSplit;
            for (String urlString : cpSplit = cp.split(File.pathSeparator)) {
                try {
                    URL url = Paths.get(urlString, new String[0]).toRealPath(new LinkOption[0]).toFile().toURI().toURL();
                    if (url == null) continue;
                    cpURLs.add(url);
                }
                catch (InvalidPathException invalidPathException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return cpURLs;
    }

    public static void loadRenew(URL baseURL, String[] args) throws MalformedURLException {
        String base = baseURL.toExternalForm();
        URL libURL = new URL(base + DIR_COMMONLIBS);
        Vector<URL> newCP = new Vector<URL>();
        newCP.addAll(Loader.classPathURLs());
        File libsDir = null;
        try {
            libsDir = new File(new URI(libURL.toExternalForm()));
            newCP.addAll(Loader.getJars(libsDir));
        }
        catch (RuntimeException e) {
            System.out.println("Loader: Libraries not found. Check your classpath! Classpath should point to loader.jar only.\nWas looking in:" + String.valueOf(libsDir));
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            System.out.println("Could not parse URL as URI. Could not load jars" + String.valueOf(libURL));
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL. Could not load jars" + String.valueOf(libURL));
            e.printStackTrace();
        }
        Object jarURL = "";
        try {
            jarURL = "jar:" + baseURL.toExternalForm() + "de.renew.loader.jar!/";
            JarURLConnection jarConnection = (JarURLConnection)new URL((String)jarURL).openConnection();
            JarFile jar = jarConnection.getJarFile();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().startsWith("libs/") || !entry.getName().endsWith(".jar")) continue;
                newCP.add(new URL((String)jarURL + entry.getName()));
            }
        }
        catch (ZipException e2) {
            System.out.println("IO excption while unpacking jar" + (String)jarURL);
            e2.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IO excption while creating classpath");
            e.printStackTrace();
        }
        URL[] urls = newCP.toArray(new URL[0]);
        ClassLoader parent = ClassLoader.getSystemClassLoader().getParent();
        URLClassLoader cl = new URLClassLoader(urls, parent);
        try {
            Class<?> pmClass = cl.loadClass("de.renew.plugin.PluginManager");
            Method mainMethod = pmClass.getDeclaredMethod("main", args.getClass(), URL.class);
            mainMethod.invoke(null, args, baseURL);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class PluginManager not found check your classpath");
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            System.out.println("PluginManager has no main method. Wrong version ?");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("IllegalArgument error while invoking PluginManagers main class");
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            System.out.println("IllegalAccess error while invoking PluginManagers main class");
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            System.out.println("InvocationTarget error while invoking PluginManagers main class");
            e.printStackTrace();
        }
    }

    private static Vector<URL> getJars(File dir) throws MalformedURLException {
        Vector<URL> v = new Vector<URL>();
        File[] files = dir.listFiles();
        for (int x = 0; x < files.length; ++x) {
            if (files[x].isFile()) {
                if (!files[x].getName().endsWith(".jar")) continue;
                v.add(files[x].toURI().toURL());
                continue;
            }
            if (!files[x].isDirectory()) continue;
            v.addAll(Loader.getJars(files[x]));
        }
        return v;
    }

    public static void startNewRenewInstance() throws IOException {
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        ArrayList<String> command = new ArrayList<String>();
        command.add(JAVA_PATH);
        command.addAll(arguments);
        if (Loader.class.getModule().isNamed()) {
            command.add("--module");
            command.add(Loader.class.getModule().getName());
        } else {
            command.add("--class-path");
            command.add(System.getProperty("java.class.path"));
            command.add(Loader.class.getName());
        }
        command.addAll(renewArgs);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.start();
    }
}

