/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.facile.mode.AbstractLocationMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.StationModeArea;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultLocationMode<A extends StationModeArea>
extends AbstractLocationMode<A> {
    @Override
    public Location current(Dockable dockable) {
        StationModeArea area = (StationModeArea)this.get(dockable, true);
        if (area == null) {
            return null;
        }
        DockableProperty location = area.getLocation(dockable);
        return new Location(this.getUniqueIdentifier(), area.getUniqueId(), location, false);
    }

    @Override
    public boolean runApply(Dockable dockable, Location history, AffectedSet set) {
        StationModeArea area = null;
        if (history != null) {
            area = (StationModeArea)this.get(history.getRoot());
        }
        if (area == null) {
            area = (StationModeArea)this.getDefaultArea();
        }
        if (area == null) {
            if (history == null) {
                throw new IllegalStateException("unable to find valid target, no history available");
            }
            throw new IllegalStateException("unable to find valid target '" + history.getRoot() + "'");
        }
        DockableProperty location = history == null ? null : history.getLocation();
        return area.setLocation(dockable, location, set);
    }

    @Override
    public boolean isCurrentMode(Dockable dockable) {
        for (StationModeArea area : this) {
            if (!area.isChild(dockable)) continue;
            return true;
        }
        return false;
    }
}

