/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.location.CWorkingAreaLocation;
import bibliothek.gui.dock.common.perspective.CWorkingPerspective;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CWorkingArea
extends CGridArea {
    public static final Path TYPE_ID = new Path("dock", "CWorkingArea");

    public CWorkingArea(CControl control, String uniqueId) {
        super(control, uniqueId);
        this.setMaximizingArea(false);
    }

    @Override
    public boolean isWorkingArea() {
        return true;
    }

    @Override
    public CLocation getStationLocation() {
        return new CWorkingAreaLocation(this);
    }

    @Override
    public CWorkingPerspective createPerspective() {
        return new CWorkingPerspective(this.getUniqueId(), this.getTypeId());
    }

    @Override
    public void deploy(CGrid grid) {
        DockableSplitDockTree tree = grid.toTree();
        for (Dockable dockable : (Dockable[])tree.getDockables()) {
            if (!(dockable instanceof CommonDockable)) continue;
            CommonDockable cdock = (CommonDockable)dockable;
            cdock.getDockable().setWorkingArea(this);
        }
        this.getStation().dropTree(tree);
    }

    public <F extends SingleCDockable> F show(F dockable) {
        this.add(dockable);
        dockable.setLocationsAsideFocused();
        dockable.setVisible(true);
        return dockable;
    }

    public <F extends MultipleCDockable> F show(F dockable) {
        this.add(dockable);
        dockable.setLocationsAsideFocused();
        dockable.setVisible(true);
        return dockable;
    }

    public <F extends SingleCDockable> F add(F dockable) {
        dockable.setWorkingArea(this);
        CControlAccess access = this.control();
        if (access != null) {
            access.getOwner().addDockable(dockable);
        }
        return dockable;
    }

    public <F extends MultipleCDockable> F add(F dockable) {
        dockable.setWorkingArea(this);
        CControlAccess access = this.control();
        if (access != null) {
            access.getOwner().addDockable(dockable);
        }
        return dockable;
    }

    @Override
    public Path getTypeId() {
        return TYPE_ID;
    }
}

