/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.PlaceInstance;
import de.renew.remote.SocketFactoryDeterminer;
import de.renew.remote.TokenCountsAccessor;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class TokenCountsAccessorImpl
extends UnicastRemoteObject
implements TokenCountsAccessor {
    public static final Logger LOGGER = Logger.getLogger(TokenCountsAccessorImpl.class);
    private int _freeTokenCount;
    private int _testedTokenCount;

    public TokenCountsAccessorImpl(final PlaceInstance placeInstance) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                placeInstance._lock.lock();
                try {
                    TokenCountsAccessorImpl.this._freeTokenCount = placeInstance.getNumberOfTokens();
                    TokenCountsAccessorImpl.this._testedTokenCount = placeInstance.getNumberOfTestedTokens();
                }
                finally {
                    placeInstance._lock.unlock();
                }
                return null;
            }
        });
        try {
            future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
    }

    @Override
    public int getFreeTokenCount() throws RemoteException {
        return this._freeTokenCount;
    }

    @Override
    public int getTestedTokenCount() throws RemoteException {
        return this._testedTokenCount;
    }

    @Override
    public boolean isEmpty() throws RemoteException {
        return this._freeTokenCount + this._testedTokenCount <= 0;
    }
}

