/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.net.Transition;
import de.renew.net.TransitionInstance;
import de.renew.remote.NetAccessor;
import de.renew.remote.NetAccessorImpl;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceInstanceAccessor;
import de.renew.remote.PlaceInstanceAccessorImpl;
import de.renew.remote.TransitionInstanceAccessor;
import de.renew.remote.TransitionInstanceAccessorImpl;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class NetInstanceAccessorImpl
extends ObjectAccessorImpl
implements NetInstanceAccessor {
    public static final Logger LOGGER = Logger.getLogger(NetInstanceAccessorImpl.class);

    public NetInstanceAccessorImpl(NetInstance netInstance, SimulationEnvironment environment) throws RemoteException {
        super(netInstance, environment);
    }

    @Override
    public NetAccessor getNet() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetAccessor>(){

            @Override
            public NetAccessor call() throws Exception {
                return new NetAccessorImpl(((NetInstance)NetInstanceAccessorImpl.this._object).getNet(), NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (NetAccessor)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public String getID() throws RemoteException {
        return ((NetInstance)this._object).getID();
    }

    @Override
    public PlaceInstanceAccessor getPlaceInstance(final NetElementID id) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<PlaceInstanceAccessor>(){

            @Override
            public PlaceInstanceAccessor call() throws Exception {
                Place place = ((NetInstance)NetInstanceAccessorImpl.this._object).getNet().getPlaceWithID(id);
                if (place == null) {
                    return null;
                }
                PlaceInstance placeInstance = ((NetInstance)NetInstanceAccessorImpl.this._object).getInstance(place);
                if (placeInstance == null) {
                    return null;
                }
                return new PlaceInstanceAccessorImpl(placeInstance, NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (PlaceInstanceAccessor)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public TransitionInstanceAccessor getTransitionInstance(final NetElementID id) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<TransitionInstanceAccessor>(){

            @Override
            public TransitionInstanceAccessor call() throws Exception {
                Transition transition = ((NetInstance)NetInstanceAccessorImpl.this._object).getNet().getTransitionWithID(id);
                if (transition == null) {
                    return null;
                }
                TransitionInstance transitionInstance = ((NetInstance)NetInstanceAccessorImpl.this._object).getInstance(transition);
                if (transitionInstance == null) {
                    return null;
                }
                return new TransitionInstanceAccessorImpl(transitionInstance, NetInstanceAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (TransitionInstanceAccessor)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    PlaceInstanceAccessor getInstance(PlaceAccessor place) throws RemoteException {
        return this.getPlaceInstance(place.getID());
    }
}

