/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.remote.NetAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.remote.PlaceAccessor;
import de.renew.remote.PlaceAccessorImpl;
import de.renew.remote.TransitionAccessor;
import de.renew.remote.TransitionAccessorImpl;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class NetAccessorImpl
extends ObjectAccessorImpl
implements NetAccessor {
    public static final Logger LOGGER = Logger.getLogger(NetAccessorImpl.class);

    public NetAccessorImpl(Net net, SimulationEnvironment env) throws RemoteException {
        super(net, env);
    }

    @Override
    public String getName() throws RemoteException {
        return ((Net)this._object).getName();
    }

    @Override
    public NetElementID[] getPlaceIDs() throws RemoteException {
        final Net net = (Net)this._object;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetElementID[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetElementID[] call() throws Exception {
                Net net2 = net;
                synchronized (net2) {
                    NetElementID[] placeIDs = new NetElementID[((Net)NetAccessorImpl.this._object).placeCount()];
                    Iterator places = net.places().iterator();
                    for (int i = 0; i < placeIDs.length; ++i) {
                        placeIDs[i] = ((Place)places.next()).getID();
                    }
                    return placeIDs;
                }
            }
        });
        try {
            return (NetElementID[])future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public PlaceAccessor getPlace(final NetElementID id) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<PlaceAccessor>(){

            @Override
            public PlaceAccessor call() throws Exception {
                Place result = ((Net)NetAccessorImpl.this._object).getPlaceWithID(id);
                if (result == null) {
                    return null;
                }
                return new PlaceAccessorImpl(result, NetAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (PlaceAccessor)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public NetElementID[] getTransitionIDs() throws RemoteException {
        final Net net = (Net)this._object;
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<NetElementID[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public NetElementID[] call() throws Exception {
                Net net2 = net;
                synchronized (net2) {
                    NetElementID[] transitionIDs = new NetElementID[((Net)NetAccessorImpl.this._object).transitionCount()];
                    Iterator transitions = net.transitions().iterator();
                    for (int i = 0; i < transitionIDs.length; ++i) {
                        transitionIDs[i] = ((Transition)transitions.next()).getID();
                    }
                    return transitionIDs;
                }
            }
        });
        try {
            return (NetElementID[])future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }

    @Override
    public TransitionAccessor getTransition(final NetElementID id) throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<TransitionAccessor>(){

            @Override
            public TransitionAccessor call() throws Exception {
                Transition result = ((Net)NetAccessorImpl.this._object).getTransitionWithID(id);
                if (result == null) {
                    return null;
                }
                return new TransitionAccessorImpl(result, NetAccessorImpl.this.getEnvironment());
            }
        });
        try {
            return (TransitionAccessor)future.get();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Simulation thread threw an exception", (Throwable)e);
        }
        return null;
    }
}

