/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.common.SimulatorEvent;
import de.renew.logging.gui.MainRepository;
import de.renew.logging.gui.StepTraceRepository;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MainRepositoryManager {
    private static final Logger LOGGER = Logger.getLogger(MainRepositoryManager.class);
    private static MainRepositoryManager _manager = null;
    private LongHashSet[] _simulationRunIds;
    private MainRepository[] _repositories;
    private static final int DEFAULT_SIMULATION_HISTORIES_DIM = 2;

    public MainRepositoryManager() {
        this(2);
    }

    public MainRepositoryManager(int simulationHistoriesDim) {
        this._simulationRunIds = new LongHashSet[simulationHistoriesDim];
        this._repositories = new MainRepository[this._simulationRunIds.length];
    }

    public static MainRepositoryManager getInstance() {
        if (_manager == null) {
            _manager = new MainRepositoryManager();
        }
        return _manager;
    }

    public long[] getSimulationRunIds() {
        int x;
        Vector<Long> idVector = new Vector<Long>();
        for (x = 0; x < this._simulationRunIds.length && this._repositories[x] != null; ++x) {
            idVector.addAll(this._simulationRunIds[x]);
        }
        long[] ids = new long[idVector.size()];
        for (x = 0; x < idVector.size(); ++x) {
            ids[x] = (Long)idVector.get(x);
        }
        return ids;
    }

    public MainRepository getRepository(long simulationRunId) {
        long[] collectedSimulationRunIds;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(MainRepositoryManager.class.getSimpleName() + " fetching main repo for runId: " + simulationRunId));
        }
        for (int x = 0; x < this._repositories.length && this._repositories[x] != null; ++x) {
            if (!this._simulationRunIds[x].contains(simulationRunId)) continue;
            return this._repositories[x];
        }
        try {
            collectedSimulationRunIds = SimulationManager.getCurrentSimulator().collectSimulationRunIds();
        }
        catch (NullPointerException e) {
            LOGGER.warn((Object)(MainRepositoryManager.class.getSimpleName() + ": Could not determine the simulation the run id " + simulationRunId + " belongs to."));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(MainRepositoryManager.class.getSimpleName() + ": " + String.valueOf(e)));
            }
            collectedSimulationRunIds = new long[]{simulationRunId};
        }
        LongHashSet newRunIds = new LongHashSet(collectedSimulationRunIds);
        if (!newRunIds.contains(simulationRunId)) {
            LOGGER.warn((Object)(MainRepositoryManager.class.getSimpleName() + ": The run id " + simulationRunId + " does not belong to the current simulation."));
            collectedSimulationRunIds = new long[]{simulationRunId};
            newRunIds = new LongHashSet(collectedSimulationRunIds);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(MainRepositoryManager.class.getSimpleName() + ": Creating new repository covering run ids " + String.valueOf(newRunIds)));
        }
        MainRepository repository = new MainRepository();
        for (int y = this._repositories.length - 1; y > 0; --y) {
            this._simulationRunIds[y] = this._simulationRunIds[y - 1];
            this._repositories[y] = this._repositories[y - 1];
        }
        this._simulationRunIds[0] = newRunIds;
        this._repositories[0] = repository;
        return repository;
    }

    public MainRepository getRepository(SimulatorEvent simEvent) {
        StepIdentifier step = simEvent.getStep();
        if (step != null) {
            long runId = step.getSimulationRunId();
            return this.getRepository(runId);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)(MainRepositoryManager.class.getSimpleName() + " found no main repo for: " + String.valueOf(simEvent)));
        }
        return null;
    }

    public StepTraceRepository getCurrentRepository(String loggerName) {
        long currentSimId = SimulationManager.getCurrentSimulator().currentStepIdentifier().getSimulationRunId();
        return this.getRepository(currentSimId).getLoggerRepository(loggerName, -1);
    }

    private static class LongHashSet
    extends HashSet<Long> {
        public LongHashSet(int size) {
            super(size);
        }

        public LongHashSet(long[] entries) {
            this(entries.length);
            for (long entry : entries) {
                this.add(entry);
            }
        }
    }
}

