/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import de.renew.gui.ComponentRenderer;
import de.renew.gui.JComponentCellEditor;
import de.renew.logging.gui.LoggerTableModel;
import de.renew.logging.gui.LoggingController;
import de.renew.logging.gui.TableModel;
import de.renew.windowmanagement.Workbench;
import de.renew.windowmanagement.WorkbenchImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class LoggingFrame {
    private static final Logger LOGGER = Logger.getLogger(LoggingFrame.class);
    private LoggingController _controller;
    private JTable _loggerTable;
    private JScrollPane _scrollPane;
    private JComboBox _loggerComboBox;
    private JCheckBox _updateCheckBox;
    private JPanel _panel;

    public LoggingFrame(LoggingController controller, String[] loggerNames, Workbench workbench) {
        this._controller = controller;
        this._panel = new JPanel();
        this.initGUI(loggerNames);
        DefaultSingleCDockable dockable = new DefaultSingleCDockable("Simulation Trace", (Component)this._panel, new CAction[0]);
        dockable.setCloseable(true);
        dockable.addVetoClosingListener(new CVetoClosingListener(){

            public void closing(CVetoClosingEvent arg0) {
            }

            public void closed(CVetoClosingEvent arg0) {
                SingleCDockable dockable = (SingleCDockable)arg0.getDockable(0);
                dockable.getControl().removeDockable(dockable);
            }
        });
        workbench.addViewWindow(dockable, WorkbenchImpl.UPPER_LEFT_GROUP);
    }

    public void initGUI(String[] loggerNames) {
        try {
            this._loggerComboBox = new JComboBox<String>(loggerNames);
            this._loggerComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    String loggerName = (String)cb.getSelectedItem();
                    LoggingFrame.this._controller.changeLogger(loggerName);
                }
            });
            this._scrollPane = new JScrollPane();
            this._loggerTable = new JTable(new TableModel(true)){

                @Override
                public TableCellRenderer getCellRenderer(int row, int column) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(column);
                    TableCellRenderer renderer = tableColumn.getCellRenderer();
                    if (renderer == null) {
                        Object o;
                        Class<?> c = this.getColumnClass(column);
                        if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                            c = this.getValueAt(row, column).getClass();
                        }
                        renderer = this.getDefaultRenderer(c);
                    }
                    return renderer;
                }

                @Override
                public TableCellEditor getCellEditor(int row, int column) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(column);
                    TableCellEditor editor = tableColumn.getCellEditor();
                    if (editor == null) {
                        Object o;
                        Class<?> c = this.getColumnClass(column);
                        if (c.equals(Object.class) && (o = this.getValueAt(row, column)) != null) {
                            c = this.getValueAt(row, column).getClass();
                        }
                        editor = this.getDefaultEditor(c);
                    }
                    return editor;
                }
            };
            TableCellRenderer defaultRenderer = this._loggerTable.getDefaultRenderer(JComponent.class);
            this._loggerTable.setDefaultRenderer(JComponent.class, (TableCellRenderer)new ComponentRenderer(defaultRenderer));
            TableCellEditor defaultEditor = this._loggerTable.getDefaultEditor(JComponent.class);
            this._loggerTable.setDefaultEditor(JComponent.class, (TableCellEditor)new JComponentCellEditor(defaultEditor, null));
            BorderLayout thisLayout = new BorderLayout();
            this._panel.setLayout(thisLayout);
            this._panel.add((Component)this._loggerComboBox, "North");
            this._panel.add((Component)this._scrollPane, "Center");
            this._scrollPane.add(this._loggerTable);
            this._scrollPane.setViewportView(this._loggerTable);
            this._updateCheckBox = new JCheckBox("permanent update");
            this._updateCheckBox.setSelected(true);
            this._updateCheckBox.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggingFrame.this._controller.setPermanentUpdate(LoggingFrame.this._updateCheckBox.isSelected());
                }
            });
            this._panel.add((Component)this._updateCheckBox, "South");
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public ComboBoxModel getComboBoxModel() {
        return this._loggerComboBox.getModel();
    }

    public void setTableModel(LoggerTableModel dm) {
        if (dm != null) {
            this._loggerTable.setModel(dm);
            dm.addTableModelListener(new TableModelListenerImpl());
            this.updateRowHeights();
        }
    }

    public LoggerTableModel getTableModel() {
        return (LoggerTableModel)this._loggerTable.getModel();
    }

    public String getSelectedLoggerName() {
        return (String)this._loggerComboBox.getSelectedItem();
    }

    public void updateRowHeights() {
        TableModel tm = (TableModel)this._loggerTable.getModel();
        for (int x = 0; x < tm.getRowCount(); ++x) {
            Object o = tm.getValueAt(x, 0);
            if (!(o instanceof JComponent)) continue;
            JComponent c = (JComponent)o;
            this._loggerTable.setRowHeight(x, c.getPreferredSize().height);
        }
    }

    public void updateRowHeight(int row) {
        TableModel tm = (TableModel)this._loggerTable.getModel();
        Object o = tm.getValueAt(row, 0);
        if (o instanceof JComponent) {
            JComponent c = (JComponent)o;
            this._loggerTable.setRowHeight(row, c.getPreferredSize().height);
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private TableModelListenerImpl() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 1 || e.getType() == 0) {
                for (int x = e.getFirstRow(); x <= e.getLastRow(); ++x) {
                    LoggingFrame.this.updateRowHeight(x);
                }
            }
        }
    }
}

