/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.logging.gui.GuiAppender;
import de.renew.logging.gui.LoggerTableModel;
import de.renew.logging.gui.LoggingFrame;
import de.renew.windowmanagement.Workbench;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LoggingController {
    private LoggingFrame _frame;
    private LoggerTableModel _currentLoggerTableModel;

    public LoggingController(Set<LoggingController> loggingFrameControllers, Workbench workbench) {
        String[] loggerNames = LoggingController.findSimulationLoggerNames();
        this._frame = new LoggingFrame(this, loggerNames, workbench);
        LoggingController controller = this;
        loggingFrameControllers.add(controller);
        if (loggerNames.length > 0) {
            this.changeLogger(loggerNames[0]);
        }
    }

    public void setPermanentUpdate(boolean update) {
        if (update) {
            this.destruct();
            this._currentLoggerTableModel = new LoggerTableModel(this._frame.getSelectedLoggerName());
            this._frame.setTableModel(this._currentLoggerTableModel);
        }
        if (this._currentLoggerTableModel != null) {
            this._currentLoggerTableModel.setPermanentUpdate(update);
        }
    }

    public void changeLogger(String loggerName) {
        this.showLogger(loggerName);
    }

    public static String[] findSimulationLoggerNames() {
        Vector<String> loggerNames = new Vector<String>();
        Enumeration ls = LogManager.getCurrentLoggers();
        while (ls.hasMoreElements()) {
            Logger logger = (Logger)ls.nextElement();
            if (!logger.getName().startsWith("simulation")) continue;
            Enumeration as = logger.getAllAppenders();
            while (as.hasMoreElements()) {
                Object o = as.nextElement();
                if (!(o instanceof GuiAppender)) continue;
                loggerNames.add(logger.getName());
            }
        }
        return loggerNames.toArray(new String[0]);
    }

    private void showLogger(String loggerName) {
        this.destruct();
        this._currentLoggerTableModel = new LoggerTableModel(loggerName);
        this._frame.setTableModel(this._currentLoggerTableModel);
    }

    public void closeFrame() {
        this.destruct();
    }

    private void destruct() {
        if (this._currentLoggerTableModel != null) {
            this._currentLoggerTableModel.removeAll();
            this._currentLoggerTableModel = null;
        }
    }
}

