/*
 * Decompiled with CFR 0.152.
 */
package de.renew.logging.gui;

import de.renew.engine.common.SimulatorEvent;
import de.renew.logging.gui.AbstractRepository;
import de.renew.logging.gui.MainRepository;
import de.renew.logging.gui.RepositoryChangeListener;
import de.renew.logging.gui.StepTrace;
import de.renew.logging.gui.StepTraceRemoveRequest;
import de.renew.logging.gui.StepTraceRepository;
import de.renew.simulatorontology.simulation.StepIdentifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class LoggerRepository
extends AbstractRepository
implements RepositoryChangeListener {
    private int _capacity = 0;
    private List<StepIdentifier> _stepTraces = new LinkedList<StepIdentifier>();
    private MainRepository _repository;

    LoggerRepository(MainRepository repository, int capacity) {
        if (capacity >= 0) {
            this._capacity = capacity;
        }
        this._repository = repository;
    }

    public void setCapacity(int capacity) {
        if (capacity >= 0) {
            this._capacity = capacity;
        }
    }

    @Override
    public StepTrace[] getStepTraces(StepIdentifier[] steps) {
        Vector<StepIdentifier> traces = new Vector<StepIdentifier>();
        for (int x = 0; x < steps.length; ++x) {
            if (!this._stepTraces.contains(steps[x])) continue;
            traces.add(steps[x]);
        }
        return this._repository.getStepTraces(traces.toArray(new StepIdentifier[0]));
    }

    @Override
    public StepTrace[] getAllStepTraces() {
        return this._repository.getStepTraces(this._stepTraces.toArray(new StepIdentifier[0]));
    }

    @Override
    public StepTrace getStepTrace(StepIdentifier stepIdentifier) {
        if (!this._stepTraces.contains(stepIdentifier)) {
            return null;
        }
        return this._repository.getStepTrace(stepIdentifier);
    }

    @Override
    public boolean removeStepTrace(StepIdentifier stepIdentifier) {
        boolean success = this._stepTraces.remove(stepIdentifier);
        if (success) {
            StepTrace stepTrace = this._repository.getStepTrace(stepIdentifier);
            this._repository.removeStepTrace(stepIdentifier);
            this.fireStepTraceRemoved(stepTrace);
        }
        return success;
    }

    @Override
    public void addEvent(SimulatorEvent event) {
        this._repository.addEvent(event);
        if (!this._stepTraces.contains(event.getStep())) {
            if (this._capacity > 0 && this._stepTraces.size() > this._capacity - 1) {
                while (this._stepTraces.size() > this._capacity - 1) {
                    StepIdentifier rStep = this._stepTraces.get(0);
                    this.removeStepTrace(rStep);
                }
            }
            this._stepTraces.add(event.getStep());
            this.fireStepTraceAdded(this._repository.getStepTrace(event.getStep()));
        }
    }

    @Override
    public void stepTraceAdded(StepTraceRepository repository, StepTrace stepTrace) {
        if (this._stepTraces.contains(stepTrace.getStepIdentifier())) {
            this.fireStepTraceAdded(stepTrace);
        }
    }

    @Override
    public void stepTraceRemoved(StepTraceRepository repository, StepTrace stepTrace) {
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest request) {
        if (this._stepTraces.contains(request.getStepTrace().getStepIdentifier())) {
            request.veto();
        } else {
            this.fireStepTraceRemoveRequest(request.getStepTrace());
        }
    }

    @Override
    public void stepTraceChanged(StepTrace stepTrace) {
        if (this._stepTraces.contains(stepTrace.getStepIdentifier())) {
            this.fireStepTraceChanged(stepTrace);
        }
    }
}

