/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.io.api.FileApi;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.FileType;
import de.renew.plugin.PluginProperties;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class PNGExportFormat
extends AbstractDrawingExportFormat {
    private static final Logger LOGGER = Logger.getLogger(PNGExportFormat.class);
    public static final String PNG_EXPORT_HOTKEY_PROP_NAME = "de.renew.hotkeymap.export.exportcurrentdrawingpng";
    private PluginProperties _plugincfg;

    public PNGExportFormat() {
        super("PNG", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.PNG));
    }

    public PNGExportFormat(PluginProperties plugincfg) {
        super("PNG", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.PNG));
        this._plugincfg = plugincfg;
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in PNGExportFormat: result == null";
        return result;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle bounds = drawing.getBounds();
        return this.internalExport(drawing, file, bounds, true);
    }

    public ByteArrayOutputStream export(Drawing drawing) throws Exception {
        Rectangle bounds = drawing.getBounds();
        return this.internalExport(drawing, bounds, true);
    }

    public File internalExport(Drawing drawing, File file, Rectangle bounds, boolean removeWhiteSpace) throws IOException {
        File pngOutput = new File(file.getAbsolutePath());
        BufferedImage netImage = this.createImage(drawing, bounds, removeWhiteSpace);
        ImageIO.write((RenderedImage)netImage, "png", pngOutput);
        return pngOutput;
    }

    public ByteArrayOutputStream internalExport(Drawing drawing, Rectangle bounds, boolean removeWhiteSpace) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        BufferedImage netImage = this.createImage(drawing, bounds, removeWhiteSpace);
        ImageIO.write((RenderedImage)netImage, "png", byteStream);
        return byteStream;
    }

    private BufferedImage createImage(Drawing drawing, Rectangle bounds, boolean removeWhiteSpace) {
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        LOGGER.info((Object)(PNGExportFormat.class.getName() + ": creating image. Size: " + width + " " + height));
        BufferedImage netImage = new BufferedImage(width, height, 2);
        Graphics2D graphics = netImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics.setComposite(AlphaComposite.Clear);
        graphics.fillRect(0, 0, width, height);
        if (removeWhiteSpace) {
            graphics.translate(x * -1, y * -1);
        }
        graphics.setComposite(AlphaComposite.SrcOver);
        drawing.draw((Graphics)graphics);
        return netImage;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        result = true;
        return result;
    }

    public int getShortCut() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME)).getKeyCode();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME).getKeyCode();
    }

    public int getModifier() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME)).getModifiers();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(PNG_EXPORT_HOTKEY_PROP_NAME).getModifiers();
    }
}

