/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.procedures;

import de.renew.momoc.core.BindingContainer;
import de.renew.momoc.core.BindingCore;
import de.renew.momoc.core.GraphFinder;
import de.renew.momoc.core.Result;
import de.renew.momoc.elements.NodeImpl;
import de.renew.momoc.net.TransitionCheckerImpl;
import de.renew.momoc.procedures.Procedure;
import de.renew.momoc.storageManagers.SimpleStorageManager;
import de.renew.momoc.storageManagers.StorageManager;
import de.renew.net.Net;
import de.renew.rgbase.gui.Aborter;
import de.renew.rgbase.gui.GraphDrawing;
import java.awt.Dimension;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

public class StdRgProcedure
extends Procedure {
    private static final String PROCEDURE_NAME = "Reachability Graph";
    private static final String PROCEDURE_DESCRIPTION = "Creates a default, exhaustive, reachability graph. Uses a breadth first search.";
    private boolean _action = true;
    private boolean _creation = false;
    private GraphFinder.TransitionChecker _transitionChecker;
    private long _maxDepth = 16L;
    private boolean _limitDepth = false;
    private int _inscMode = 0;
    private StorageManager _storageManager;

    public Result start(Net startNet, long maxDepth, GraphFinder.TransitionChecker checker, Aborter aborter) {
        this._maxDepth = maxDepth;
        this._transitionChecker = checker;
        return this.start(startNet, aborter, (String)null);
    }

    @Override
    public Result start(Net startNet, Aborter aborter, String formula) {
        int progress = 0;
        long time = System.currentTimeMillis();
        NodeImpl startNode = new NodeImpl(startNet);
        if (this._transitionChecker == null) {
            this._transitionChecker = new TransitionCheckerImpl(this._action, this._creation);
        }
        BindingCore bindingCore = new BindingCore(this._transitionChecker);
        this._storageManager = new SimpleStorageManager(startNode);
        LinkedList<NodeImpl> queue = new LinkedList<NodeImpl>();
        NodeImpl node = startNode;
        while (node != null && !aborter.abort()) {
            if (!this._limitDepth || node.getDepth() != this._maxDepth) {
                Collection<BindingContainer> bindingContainers = bindingCore.executeMultipleBindings(node, bindingCore.getBindings(node));
                Collection<NodeImpl> newNodes = this._storageManager.addMultipleIfNonexistent(node, bindingContainers);
                queue.addAll(newNodes);
            } else {
                GraphFinder.TransitionChecker transitionChecker = trans -> false;
                bindingCore.getBindingsWithCustomTransitionChecker(node, transitionChecker);
            }
            node = (NodeImpl)((Object)queue.poll());
            ++progress;
            if (System.currentTimeMillis() - 1000L <= time) continue;
            this.informAboutProgress(progress + " nodes");
            time = System.currentTimeMillis();
        }
        Result result = new Result(this._storageManager.getReachabilityGraph());
        result.setReachabilityGraphOnly(true);
        result.setInscMode(this._inscMode);
        return result;
    }

    @Override
    public JPanel additionalParameterSettings() {
        return new SettingsPanel();
    }

    @Override
    public String toString() {
        return PROCEDURE_NAME;
    }

    @Override
    public String description() {
        return PROCEDURE_DESCRIPTION;
    }

    @Override
    public boolean allowCustomStorageManager() {
        return true;
    }

    class SettingsPanel
    extends JPanel {
        public SettingsPanel() {
            JCheckBox actionBox = new JCheckBox("Skip Action Execution", StdRgProcedure.this._action);
            actionBox.addItemListener(e -> {
                StdRgProcedure.this._action = e.getStateChange() == 1;
            });
            actionBox.setToolTipText("Do not explore bindings that would fire transitions with action inscriptions.");
            JCheckBox creationBox = new JCheckBox("Skip Net Instance Creation", StdRgProcedure.this._creation);
            creationBox.addItemListener(e -> {
                StdRgProcedure.this._creation = e.getStateChange() == 1;
            });
            creationBox.setToolTipText("Do not explore bindings that would create new net instances.");
            JComboBox<String> inscBox = new JComboBox<String>(GraphDrawing.INSC_MODES);
            inscBox.setSelectedIndex(StdRgProcedure.this._inscMode);
            inscBox.addActionListener(e -> {
                StdRgProcedure.this._inscMode = inscBox.getSelectedIndex();
            });
            inscBox.setToolTipText("Inscription of the reachability graph's nodes");
            final JFormattedTextField depthField = new JFormattedTextField(StdRgProcedure.this._maxDepth);
            depthField.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    JFormattedTextField.AbstractFormatter formatter = depthField.getFormatter();
                    try {
                        Object newValue = formatter.stringToValue(depthField.getText());
                        if (newValue instanceof Long && (Long)newValue >= 0L) {
                            return true;
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    return false;
                }
            });
            depthField.addPropertyChangeListener(evt -> {
                StdRgProcedure.this._maxDepth = (Long)depthField.getValue();
            });
            depthField.setEnabled(StdRgProcedure.this._limitDepth);
            depthField.setHorizontalAlignment(11);
            depthField.setToolTipText("Maximum depth up to which graph nodes are explored.");
            JCheckBox depthBox = new JCheckBox("Depth Limit", StdRgProcedure.this._limitDepth);
            depthBox.addItemListener(e -> {
                StdRgProcedure.this._limitDepth = e.getStateChange() == 1;
                depthField.setEnabled(StdRgProcedure.this._limitDepth);
            });
            depthBox.setToolTipText("Stop exploring graph nodes after reaching this depth.");
            JPanel paramPane = new JPanel();
            paramPane.setLayout(new BoxLayout(paramPane, 1));
            paramPane.add(actionBox);
            paramPane.add(creationBox);
            paramPane.add(Box.createRigidArea(new Dimension(0, 5)));
            JPanel inscPane = new JPanel();
            inscPane.setLayout(new BoxLayout(inscPane, 1));
            inscPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Node Inscriptions"));
            inscPane.add(inscBox);
            this.limitMaxHeight(inscBox);
            inscBox.setAlignmentX(0.0f);
            paramPane.add(inscPane);
            JPanel depthPane = new JPanel();
            depthPane.setLayout(new BoxLayout(depthPane, 0));
            depthPane.add(depthBox);
            depthPane.add(Box.createRigidArea(new Dimension(5, 0)));
            depthPane.add(depthField);
            depthPane.add(Box.createRigidArea(new Dimension(5, 0)));
            this.limitMaxHeight(depthField);
            depthPane.setAlignmentX(0.0f);
            paramPane.add(depthPane);
            paramPane.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(paramPane);
        }

        private void limitMaxHeight(JComponent component) {
            component.setMaximumSize(new Dimension(component.getMaximumSize().width, component.getPreferredSize().height));
        }
    }
}

