/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.procedures;

import de.renew.momoc.core.Result;
import de.renew.momoc.elements.Graph;
import de.renew.momoc.parser.atomicPropositions.Deadlock;
import de.renew.momoc.procedures.CTLModelChecker;
import de.renew.momoc.procedures.Procedure;
import de.renew.momoc.procedures.StdRgProcedure;
import de.renew.momoc.util.MomocConfigurationException;
import de.renew.momoc.util.Tarjan;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.rgbase.elements.Node;
import de.renew.rgbase.gui.Aborter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PropertyChecker
extends Procedure {
    private static final Logger log = Logger.getLogger(PropertyChecker.class);
    private Aborter _aborter;
    private Result _result;
    private Graph _reachabilityGraph;
    private boolean _deadlockFree;

    @Override
    public Result start(Net initialMarking, Aborter aborter, String formula) throws MomocConfigurationException {
        log.info((Object)("Starting property check on " + initialMarking.getName()));
        this._aborter = aborter;
        StdRgProcedure stdrgp = new StdRgProcedure();
        stdrgp.addProgressListener(this::informAboutProgress);
        this._reachabilityGraph = stdrgp.start(initialMarking, aborter, (String)null).getReachabilityGraph();
        if (aborter.abort()) {
            return null;
        }
        this._result = new Result(this._reachabilityGraph);
        this.informAboutProgress("deadlock");
        this.checkDeadlock();
        this.informAboutProgress("rootliveness");
        this.checkRootLiveness();
        this.informAboutProgress("reversibility");
        this.checkReversibility();
        return aborter.abort() ? null : this._result;
    }

    private void checkDeadlock() {
        log.info((Object)"Checking deadlock");
        this._deadlockFree = true;
        Deadlock deadlock = new Deadlock();
        for (Node node : this._reachabilityGraph.getNodes()) {
            this._deadlockFree = this._deadlockFree && !deadlock.holds(node);
        }
        log.info((Object)("Deadlock-Free: " + this._deadlockFree));
        this._result.addAdditionalResult("Deadlock-Free", String.valueOf(this._deadlockFree));
    }

    private void checkRootLiveness() throws MomocConfigurationException {
        boolean rootNetLiveness = true;
        if (!this._deadlockFree) {
            log.info((Object)"Net is not deadlock free. Skipping liveness..");
            rootNetLiveness = false;
        } else {
            log.info((Object)"Checking liveness");
            NetInstance rootNetInstance = this._reachabilityGraph.getStartNode().getRootNetInstance();
            Collection transitions = rootNetInstance.getNet().transitions();
            for (Transition transition : transitions) {
                String f = "AGEF FIREABLE(" + transition.toString() + ")";
                this._reachabilityGraph.resetLabels();
                Result result = new CTLModelChecker().start(this._aborter, f, this._reachabilityGraph);
                if (result.getFulfillsSpecification().booleanValue()) continue;
                log.info((Object)("Transition " + String.valueOf(transition) + " does not have the liveness-property."));
                rootNetLiveness = false;
                break;
            }
        }
        this._result.addAdditionalResult("Root-Net Liveness", String.valueOf(rootNetLiveness));
    }

    private void checkReversibility() {
        boolean reversible;
        if (!this._deadlockFree || this._reachabilityGraph.getStartNode().getPredecessors().isEmpty() && this._reachabilityGraph.getNodes().size() > 1) {
            log.info((Object)"Net is not deadlock free or startnode has no ingoing edges and is not the only node. Skipping reversibility...");
            reversible = false;
        } else {
            log.info((Object)"Checking reversibility");
            HashSet<Node> nodes = new HashSet<Node>(this._reachabilityGraph.getNodes());
            Tarjan tarjan = new Tarjan(nodes);
            Set<Set<Node>> sccs = tarjan.getSCCs();
            reversible = sccs.size() == 1;
            log.info((Object)("Found " + sccs.size() + " SCCs. Nets with exactly 1 SCC are reversible."));
        }
        this._result.addAdditionalResult("Reversible", String.valueOf(reversible));
    }

    @Override
    public JPanel additionalParameterSettings() {
        return null;
    }

    @Override
    public String toString() {
        return "Property Checker";
    }

    @Override
    public String description() {
        return "Checks Deadlock-freedom, Reversibility and Root Net Liveness";
    }

    @Override
    public boolean allowCustomStorageManager() {
        return false;
    }
}

