/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.processing;

import de.renew.momoc.parser.atomicPropositions.AtomicProposition;
import de.renew.momoc.parser.atomicPropositions.False;
import de.renew.momoc.parser.atomicPropositions.True;
import de.renew.momoc.parser.nodes.CTLNode;

public final class CTLSimplifier {
    public static CTLNode simplifyCTL(CTLNode tree) {
        CTLNode oldTree = tree;
        CTLNode newTree = CTLSimplifier.simplifyCTLInner(tree);
        while (!oldTree.equals(newTree)) {
            oldTree = newTree;
            newTree = CTLSimplifier.simplifyCTLInner(newTree);
        }
        return newTree;
    }

    private static CTLNode simplifyCTLInner(CTLNode tree) {
        switch (tree.getNodeType()) {
            case EX: {
                return CTLSimplifier.simplifyEX(tree);
            }
            case EG: {
                return CTLSimplifier.simplifyEG(tree);
            }
            case EU: {
                return CTLSimplifier.simplifyEU(tree);
            }
            case NOT: {
                return CTLSimplifier.simplifyNot(tree);
            }
            case OR: {
                return CTLSimplifier.simplifyOr(tree);
            }
            case AND: {
                return CTLSimplifier.simplifyAnd(tree);
            }
            case AP: {
                return tree;
            }
        }
        throw new RuntimeException("Could not recognize " + String.valueOf((Object)tree.getNodeType()));
    }

    private static CTLNode simplifyEX(CTLNode tree) {
        return new CTLNode(CTLSimplifier.simplifyCTLInner((CTLNode)tree.getFormula1()), CTLNode.NodeTypes.EX);
    }

    private static CTLNode simplifyEG(CTLNode tree) {
        return new CTLNode(CTLSimplifier.simplifyCTLInner((CTLNode)tree.getFormula1()), CTLNode.NodeTypes.EG);
    }

    private static CTLNode simplifyEU(CTLNode tree) {
        CTLNode subtree2 = (CTLNode)tree.getFormula2();
        if (subtree2.getNodeType() == CTLNode.NodeTypes.AP) {
            AtomicProposition ap2 = subtree2.getAtomicProposition();
            if (ap2 instanceof True) {
                return new CTLNode(new True());
            }
            if (ap2 instanceof False) {
                return new CTLNode(new False());
            }
        } else if (((CTLNode)tree.getFormula1()).getNodeType() == CTLNode.NodeTypes.AP && ((CTLNode)tree.getFormula1()).getAtomicProposition() instanceof False) {
            return CTLSimplifier.simplifyCTLInner((CTLNode)tree.getFormula2());
        }
        return new CTLNode(CTLSimplifier.simplifyCTLInner((CTLNode)tree.getFormula1()), CTLSimplifier.simplifyCTLInner(subtree2), CTLNode.NodeTypes.EU);
    }

    private static CTLNode simplifyNot(CTLNode tree) {
        CTLNode subtree = (CTLNode)tree.getFormula1();
        switch (subtree.getNodeType()) {
            case NOT: {
                return CTLSimplifier.simplifyCTLInner((CTLNode)subtree.getFormula1());
            }
            case AP: {
                AtomicProposition ap = subtree.getAtomicProposition();
                if (ap instanceof True) {
                    return new CTLNode(new False());
                }
                if (ap instanceof False) {
                    return new CTLNode(new True());
                }
                return tree;
            }
        }
        return new CTLNode(CTLSimplifier.simplifyCTLInner(subtree), CTLNode.NodeTypes.NOT);
    }

    private static CTLNode simplifyAnd(CTLNode tree) {
        CTLNode subtree1 = (CTLNode)tree.getFormula1();
        CTLNode subtree2 = (CTLNode)tree.getFormula2();
        CTLNode.NodeTypes type1 = subtree1.getNodeType();
        CTLNode.NodeTypes type2 = subtree2.getNodeType();
        if (type1 == CTLNode.NodeTypes.AP) {
            AtomicProposition apType1 = subtree1.getAtomicProposition();
            if (apType1 instanceof True) {
                return CTLSimplifier.simplifyCTLInner(subtree2);
            }
            if (apType1 instanceof False) {
                return new CTLNode(new False());
            }
        } else if (type2 == CTLNode.NodeTypes.AP) {
            AtomicProposition apType2 = subtree2.getAtomicProposition();
            if (apType2 instanceof True) {
                return CTLSimplifier.simplifyCTLInner(subtree1);
            }
            if (apType2 instanceof False) {
                return new CTLNode(new False());
            }
        }
        return new CTLNode(CTLSimplifier.simplifyCTLInner(subtree1), CTLSimplifier.simplifyCTLInner(subtree2), CTLNode.NodeTypes.AND);
    }

    private static CTLNode simplifyOr(CTLNode tree) {
        CTLNode subtree1 = (CTLNode)tree.getFormula1();
        CTLNode subtree2 = (CTLNode)tree.getFormula2();
        CTLNode.NodeTypes type1 = subtree1.getNodeType();
        CTLNode.NodeTypes type2 = subtree2.getNodeType();
        if (type1 == CTLNode.NodeTypes.AP) {
            AtomicProposition apType1 = subtree1.getAtomicProposition();
            if (apType1 instanceof True) {
                return new CTLNode(new True());
            }
            if (apType1 instanceof False) {
                return CTLSimplifier.simplifyCTLInner(subtree2);
            }
        } else if (type2 == CTLNode.NodeTypes.AP) {
            AtomicProposition apType2 = subtree2.getAtomicProposition();
            if (apType2 instanceof True) {
                return new CTLNode(new True());
            }
            if (apType2 instanceof False) {
                return CTLSimplifier.simplifyCTLInner(subtree1);
            }
        }
        return new CTLNode(CTLSimplifier.simplifyCTLInner(subtree1), CTLSimplifier.simplifyCTLInner(subtree2), CTLNode.NodeTypes.OR);
    }

    private CTLSimplifier() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

