/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.processing;

import de.renew.momoc.parser.atomicPropositions.AtomicPropositionsClassifier;
import de.renew.momoc.parser.atomicPropositions.netPredicates.BoolOperatorNetInstancePredicate;
import de.renew.momoc.parser.atomicPropositions.netPredicates.MarkingPredicate;
import de.renew.momoc.parser.atomicPropositions.netPredicates.NetInstancePredicate;
import de.renew.momoc.parser.grammars.CTLParser;
import de.renew.momoc.parser.nodes.CTLNode;
import de.renew.momoc.util.MomocConfigurationException;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;

public final class CTLNormalizer {
    private static final Map<String, String> _netQuantors = Map.of("!", "NetInstanceAll", "?", "NetInstanceExists");

    public static CTLNode constructNormalizedTree(CTLParser.CtlContext ctx) throws MomocConfigurationException {
        return CTLNormalizer.visitFormula(ctx.formula());
    }

    private static CTLNode visitFormula(CTLParser.FormulaContext ctx) throws MomocConfigurationException {
        switch (((ParserRuleContext)ctx.getChild(0)).getRuleIndex()) {
            case 2: {
                return CTLNormalizer.visitFormula(ctx.brackets().formula());
            }
            case 20: {
                return CTLNormalizer.visitAP(ctx.ap());
            }
            case 3: {
                return CTLNormalizer.visitBinaryBool(ctx.binaryBool());
            }
            case 4: {
                return CTLNormalizer.visitUnaryBool(ctx.unaryBool());
            }
            case 5: {
                return CTLNormalizer.visitUnaryOpForm(ctx.unaryOpForm());
            }
            case 6: {
                return CTLNormalizer.visitBinaryOpForm(ctx.binaryOpForm());
            }
        }
        throw new RuntimeException("Unknown rule: " + ctx.getText());
    }

    private static CTLNode visitAP(CTLParser.ApContext ctx) throws MomocConfigurationException {
        if (ctx.NoArgTerm() != null) {
            return new CTLNode(AtomicPropositionsClassifier.classify(ctx.NoArgTerm().getText()));
        }
        if (ctx.unaryTerm() != null) {
            CTLParser.UnaryTermContext argCtx = ctx.unaryTerm();
            String function = argCtx.UnaryFunction().getText();
            String arg = argCtx.argument().getText();
            return new CTLNode(AtomicPropositionsClassifier.classify(function, new String[]{arg}));
        }
        if (ctx.Bool() != null) {
            return new CTLNode(AtomicPropositionsClassifier.classify(ctx.Bool().getText()));
        }
        if (ctx.netInstanceTerm() != null) {
            String quantifierShort = ctx.netInstanceTerm().NetInstanceQuantifier().getText();
            String quantifier = _netQuantors.get(quantifierShort);
            String netType = ctx.netInstanceTerm().argument().getText();
            CTLParser.NetInstancePredicateContext predicateContext = ctx.netInstanceTerm().netInstancePredicate();
            NetInstancePredicate predicate = CTLNormalizer.visitNetInstancePredicate(predicateContext);
            return new CTLNode(AtomicPropositionsClassifier.classify(quantifier, predicate, new String[]{netType}));
        }
        return null;
    }

    private static NetInstancePredicate visitNetInstancePredicate(CTLParser.NetInstancePredicateContext ctx) {
        switch (((ParserRuleContext)ctx.getChild(0)).getRuleIndex()) {
            case 24: {
                return CTLNormalizer.visitNetInstancePredicate(ctx.netInstancePredicateBrackets().netInstancePredicate());
            }
            case 25: {
                CTLParser.NetInstancePredicateBinaryBoolContext bctx = ctx.netInstancePredicateBinaryBool();
                BoolOperatorNetInstancePredicate.NodeTypes type = bctx.boolOp().or() != null ? BoolOperatorNetInstancePredicate.NodeTypes.OR : BoolOperatorNetInstancePredicate.NodeTypes.AND;
                return new BoolOperatorNetInstancePredicate(CTLNormalizer.visitNetInstancePredicate(bctx.netInstancePredicate(0)), CTLNormalizer.visitNetInstancePredicate(bctx.netInstancePredicate(1)), type);
            }
            case 26: {
                CTLParser.NetInstancePredicateUnaryBoolContext unaryBoolCtx = ctx.netInstancePredicateUnaryBool();
                return new BoolOperatorNetInstancePredicate(CTLNormalizer.visitNetInstancePredicate(unaryBoolCtx.netInstancePredicate()), BoolOperatorNetInstancePredicate.NodeTypes.NOT);
            }
            case 27: {
                CTLParser.MarkingPredicateContext mctx = ctx.markingPredicate();
                if (mctx.cardinalityPredicate() != null) {
                    CTLParser.CardinalityPredicateContext cctx = mctx.cardinalityPredicate();
                    String placeName = cctx.argument().getText();
                    int num = Integer.parseInt(cctx.number().getText());
                    String compareOp = cctx.compareOp().getText();
                    return new MarkingPredicate(placeName, num, compareOp);
                }
                if (mctx.contentPredicate() == null) break;
                CTLParser.ContentPredicateContext cctx = mctx.contentPredicate();
                String placeName = cctx.argument(0).getText();
                String searchString = cctx.argument(1).getText();
                String containmentOp = cctx.containmentOp().getText();
                return new MarkingPredicate(placeName, searchString, containmentOp);
            }
        }
        throw new RuntimeException("Unknown rule: " + ctx.getText());
    }

    private static CTLNode visitBinaryBool(CTLParser.BinaryBoolContext ctx) throws MomocConfigurationException {
        CTLNode.NodeTypes type = ctx.boolOp().or() != null ? CTLNode.NodeTypes.OR : CTLNode.NodeTypes.AND;
        CTLNode f1 = CTLNormalizer.visitFormula(ctx.formula(0));
        CTLNode f2 = CTLNormalizer.visitFormula(ctx.formula(1));
        return new CTLNode(f1, f2, type);
    }

    private static CTLNode visitUnaryBool(CTLParser.UnaryBoolContext ctx) throws MomocConfigurationException {
        CTLNode f1 = CTLNormalizer.visitFormula(ctx.formula());
        return new CTLNode(f1, CTLNode.NodeTypes.NOT);
    }

    private static CTLNode visitUnaryOpForm(CTLParser.UnaryOpFormContext ctx) throws MomocConfigurationException {
        CTLNode f1 = CTLNormalizer.visitFormula(ctx.formula());
        if (ctx.pathQuantifier().allpath() != null) {
            CTLNode notF1 = new CTLNode(f1, CTLNode.NodeTypes.NOT);
            if (ctx.unaryTemporalOperator().always() != null) {
                CTLNode trueNode = new CTLNode(AtomicPropositionsClassifier.classify("True"));
                CTLNode eTrueUf1 = new CTLNode(trueNode, notF1, CTLNode.NodeTypes.EU);
                return new CTLNode(eTrueUf1, CTLNode.NodeTypes.NOT);
            }
            if (ctx.unaryTemporalOperator().eventually() != null) {
                CTLNode egNotf1 = new CTLNode(notF1, CTLNode.NodeTypes.EG);
                return new CTLNode(egNotf1, CTLNode.NodeTypes.NOT);
            }
            if (ctx.unaryTemporalOperator().next() != null) {
                CTLNode exNotf1 = new CTLNode(notF1, CTLNode.NodeTypes.EX);
                return new CTLNode(exNotf1, CTLNode.NodeTypes.NOT);
            }
            throw new RuntimeException("No Temporal Operator detected: " + ctx.getText());
        }
        if (ctx.pathQuantifier().expath() != null) {
            if (ctx.unaryTemporalOperator().always() != null) {
                return new CTLNode(f1, CTLNode.NodeTypes.EG);
            }
            if (ctx.unaryTemporalOperator().eventually() != null) {
                CTLNode trueNode = new CTLNode(AtomicPropositionsClassifier.classify("True"));
                return new CTLNode(trueNode, f1, CTLNode.NodeTypes.EU);
            }
            if (ctx.unaryTemporalOperator().next() != null) {
                return new CTLNode(f1, CTLNode.NodeTypes.EX);
            }
            throw new RuntimeException("No Temporal operator detected: " + ctx.getText());
        }
        throw new RuntimeException("No path quantifier detected: " + ctx.getText());
    }

    private static CTLNode visitBinaryOpForm(CTLParser.BinaryOpFormContext ctx) throws MomocConfigurationException {
        CTLNode f1 = CTLNormalizer.visitFormula(ctx.formula(0));
        CTLNode f2 = CTLNormalizer.visitFormula(ctx.formula(1));
        if (ctx.pathQuantifier().allpath() != null) {
            if (ctx.binaryTemporalOperator().until() != null) {
                CTLNode notf1 = new CTLNode(f1, CTLNode.NodeTypes.NOT);
                CTLNode notf2 = new CTLNode(f2, CTLNode.NodeTypes.NOT);
                CTLNode notf1AndNotf2 = new CTLNode(notf1, notf2, CTLNode.NodeTypes.AND);
                CTLNode euNot1And = new CTLNode(notf2, notf1AndNotf2, CTLNode.NodeTypes.EU);
                CTLNode notEUNot1And = new CTLNode(euNot1And, CTLNode.NodeTypes.NOT);
                CTLNode egNotf2 = new CTLNode(notf2, CTLNode.NodeTypes.EG);
                CTLNode notEGNotf2 = new CTLNode(egNotf2, CTLNode.NodeTypes.NOT);
                return new CTLNode(notEUNot1And, notEGNotf2, CTLNode.NodeTypes.AND);
            }
            throw new RuntimeException("No Temporal Operator detected: " + ctx.getText());
        }
        if (ctx.pathQuantifier().expath() != null) {
            if (ctx.binaryTemporalOperator().until() != null) {
                return new CTLNode(f1, f2, CTLNode.NodeTypes.EU);
            }
            throw new RuntimeException("No Temporal Operator detected: " + ctx.getText());
        }
        throw new RuntimeException("No path quantifier detected: " + ctx.getText());
    }

    private CTLNormalizer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

