/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.nodes;

import de.renew.momoc.parser.nodes.AbstractNode;
import de.renew.momoc.parser.nodes.RegisteredNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.UIManager;

public class NodeManager<T extends AbstractNode<T>> {
    private final HashMap<T, Short> _allNodes = new HashMap();
    private Short _labelCounter = 1;
    private final HashMap<Short, RegisteredNode> _registeredNodes = new HashMap();

    public List<RegisteredNode> registerMultipleTrees(Collection<T> trees) {
        LinkedList<RegisteredNode> roots = new LinkedList<RegisteredNode>();
        for (AbstractNode tree : trees) {
            roots.add(this.registerTree(tree));
        }
        return roots;
    }

    public RegisteredNode registerTree(T tree) {
        RegisteredNode<T> rootNode = this.registerTreeInner(tree);
        return rootNode;
    }

    private RegisteredNode<T> registerTreeInner(T tree) {
        Short id = this.registerNode(tree);
        RegisteredNode<T> registeredNode = this._registeredNodes.get(id);
        if (registeredNode == null) {
            if (((AbstractNode)tree).getAtomicProposition() != null) {
                registeredNode = new RegisteredNode<T>(id, null, null, tree);
                this._registeredNodes.put(id, registeredNode);
            } else {
                Short f1 = this.registerTree(((AbstractNode)tree).getFormula1()).getId();
                Object formula2 = ((AbstractNode)tree).getFormula2();
                Short f2 = formula2 != null ? Short.valueOf(this.registerTree(formula2).getId()) : null;
                registeredNode = new RegisteredNode<T>(id, f1, f2, tree);
                this._registeredNodes.put(id, registeredNode);
            }
        }
        return registeredNode;
    }

    public LinkedList<HashSet<RegisteredNode<T>>> registerTreeToList(T tree) {
        RegisteredNode registeredTree = this.registerTree(tree);
        return this.convertTreeToList(registeredTree);
    }

    public LinkedList<HashSet<RegisteredNode<T>>> convertTreeToList(RegisteredNode<T> tree) {
        if (tree == null) {
            return null;
        }
        HashMap<Short, Short> depths = new HashMap<Short, Short>();
        this.traverseTree(tree, depths);
        LinkedList<HashSet<RegisteredNode<T>>> nodeList = new LinkedList<HashSet<RegisteredNode<T>>>();
        short currentDepth = 0;
        while (depths.containsValue(currentDepth)) {
            HashSet set = new HashSet();
            short finalCurrentDepth = currentDepth;
            depths.forEach((key, value) -> {
                if (value == finalCurrentDepth) {
                    set.add(this._registeredNodes.get(key));
                }
            });
            nodeList.add(set);
            currentDepth = (short)(currentDepth + 1);
        }
        return nodeList;
    }

    public Short traverseTree(RegisteredNode<T> node, Map<Short, Short> depths) {
        short depth;
        if (node == null) {
            depth = 0;
        } else if (node.getFormula1() == null) {
            depths.put(node.getId(), (short)0);
            depth = 0;
        } else {
            RegisteredNode node1 = this._registeredNodes.get(node.getFormula1());
            RegisteredNode node2 = this._registeredNodes.get(node.getFormula2());
            depth = (short)Math.max(this.traverseTree(node1, depths).shortValue(), this.traverseTree(node2, depths).shortValue());
            if (depths.containsKey(node.getId())) {
                depth = (short)Math.max(depth, depths.get(node.getId()).shortValue());
            }
            depths.put(node.getId(), depth);
        }
        return (short)(depth + 1);
    }

    private Short registerNode(T node) {
        if (node == null) {
            return null;
        }
        Short id = this._allNodes.get(node);
        if (id == null) {
            id = this._labelCounter;
            UIManager.put(node, id);
            this._allNodes.put(node, id);
            Short s = this._labelCounter;
            this._labelCounter = (short)(this._labelCounter + 1);
        }
        return id;
    }

    public RegisteredNode getNode(Short id) {
        return this._registeredNodes.get(id);
    }

    public Short getNodeId(T node) {
        return this._allNodes.get(node);
    }
}

