/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser.atomicPropositions;

import de.renew.momoc.parser.atomicPropositions.AtomicProposition;
import de.renew.momoc.parser.atomicPropositions.netPredicates.NetInstancePredicate;
import de.renew.momoc.util.MomocConfigurationException;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class AtomicPropositionsClassifier {
    private static final Logger log = Logger.getLogger(AtomicPropositionsClassifier.class);
    private static final String AP_PATH = AtomicPropositionsClassifier.class.getPackageName();

    public static AtomicProposition classify(String ap) throws MomocConfigurationException {
        return AtomicPropositionsClassifier.classify(ap, null);
    }

    public static AtomicProposition classify(String ap, String[] arg) throws MomocConfigurationException {
        if (ap.isBlank()) {
            log.error((Object)"Tried to load empty atomic proposition!");
            throw new MomocConfigurationException("Tried to load empty atomic proposition!");
        }
        try {
            Class atomicClass = AtomicPropositionsClassifier.getClass(AP_PATH, ap);
            if (arg == null) {
                log.trace((Object)("Loading " + ap + " without any arguments."));
                return (AtomicProposition)atomicClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            log.trace((Object)("Loading " + ap + " with arguments."));
            return (AtomicProposition)atomicClass.getDeclaredConstructor(String[].class).newInstance(new Object[]{arg});
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Could not find corresponding Class to " + ap + " in " + AP_PATH + "!"));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        throw new MomocConfigurationException("Class loading for " + ap + " failed. Aborting procedure...");
    }

    public static AtomicProposition classify(String ap, NetInstancePredicate predicate, String[] arg) throws MomocConfigurationException {
        String packagePath = NetInstancePredicate.class.getPackageName();
        try {
            Class atomicClass = AtomicPropositionsClassifier.getClass(packagePath, ap);
            if (arg == null) {
                return (AtomicProposition)atomicClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (AtomicProposition)atomicClass.getDeclaredConstructor(NetInstancePredicate.class, String[].class).newInstance(predicate, arg);
        }
        catch (ClassNotFoundException e) {
            throw new MomocConfigurationException("Could not find corresponding Class to " + ap + " in " + packagePath + ".", e.getException());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable exception = e.getTargetException();
            throw new MomocConfigurationException(exception.getMessage(), exception.getCause());
        }
        throw new MomocConfigurationException("Class loading for " + ap + " failed. Aborting procedure...");
    }

    private static Class getClass(String packagePath, String apName) throws ClassNotFoundException {
        String classSyntax = apName.substring(0, 1).toUpperCase() + apName.substring(1).toLowerCase();
        return Class.forName(packagePath + "." + classSyntax);
    }
}

