/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.parser;

import de.renew.momoc.parser.grammars.CTLLexer;
import de.renew.momoc.parser.grammars.CTLParser;
import de.renew.momoc.parser.nodes.CTLNode;
import de.renew.momoc.parser.processing.CTLNormalizer;
import de.renew.momoc.parser.processing.ThrowingErrorListener;
import de.renew.momoc.util.MomocConfigurationException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;

public final class ParserManager {
    public static final String CORRECT_SYNTAX = "Syntax is correct";

    public static CTLParser.CtlContext parseCTL(String formula) throws ParseCancellationException {
        CodePointCharStream input = CharStreams.fromString((String)formula);
        CTLLexer lexer = new CTLLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CTLParser parser = new CTLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)ThrowingErrorListener.INSTANCE);
        return parser.ctl();
    }

    public static String testCTL(String formula) {
        try {
            ParserManager.parseCTL(formula);
            return CORRECT_SYNTAX;
        }
        catch (ParseCancellationException e) {
            return e.getMessage();
        }
    }

    public static CTLNode normalizeCTL(CTLParser.CtlContext tree) throws MomocConfigurationException {
        return CTLNormalizer.constructNormalizedTree(tree);
    }

    private ParserManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

