/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.net;

import de.renew.momoc.util.AggregateConversionHelper;
import de.renew.net.MultisetPlaceInstance;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.net.NetInstanceImpl;
import de.renew.net.Place;
import de.renew.net.PlaceInstance;
import de.renew.unify.Aggregate;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResettableNetInstance
extends NetInstanceImpl {
    static final int HASH_CODE_MAX_DEPTH = 4;
    String _originalId;

    public ResettableNetInstance(Net net, boolean wantInitialTokens) throws Impossible {
        super(net, wantInitialTokens);
        this._originalId = super.getID();
    }

    public ResettableNetInstance(NetInstance other) throws Impossible {
        this(other, null);
    }

    public ResettableNetInstance(NetInstance other, Map<NetInstance, ResettableNetInstance> copyMap) throws Impossible {
        super(other.getNet(), false);
        this.setOriginalID(other);
        this.setTo(other, copyMap);
    }

    private void setOriginalID(NetInstance other) {
        this._originalId = other instanceof ResettableNetInstance ? ((ResettableNetInstance)other)._originalId : other.getID();
    }

    public String getID() {
        return this._originalId + "," + super.getID();
    }

    public String toString() {
        return String.valueOf(this.getNet()) + "[" + this._originalId + "]";
    }

    public ResettableNetInstance copy() {
        return this.copy(null, null);
    }

    public ResettableNetInstance copy(Map<NetInstance, ResettableNetInstance> copyMap, Collection<NetInstance> containedNetIntances) {
        try {
            return new ResettableNetInstance((NetInstance)this, copyMap);
        }
        catch (Impossible e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<NetInstance> setTo(NetInstance other) {
        return this.setTo(other, null);
    }

    public Set<NetInstance> setTo(NetInstance other, Map<NetInstance, ResettableNetInstance> copyMap) {
        assert (this.getNet() == other.getNet());
        if (other == this) {
            return null;
        }
        HashSet<NetInstance> containedNetInstances = new HashSet<NetInstance>();
        this.setOriginalID(other);
        for (Place place : this.getNet().places()) {
            MultisetPlaceInstance myInst = (MultisetPlaceInstance)this.getInstance(place);
            PlaceInstance otInst = other.getInstance(place);
            myInst.extractAllTokens(null, null);
            Set tokens = otInst.getDistinctTestableTokens();
            for (Object token : tokens) {
                int count = otInst.getTokenCount(token);
                if (token == other) {
                    token = this;
                } else if (token instanceof NetInstance) {
                    if (copyMap != null) {
                        NetInstance instance = (NetInstance)token;
                        containedNetInstances.add(instance);
                        ResettableNetInstance replacement = copyMap.get(instance);
                        if (replacement == null) {
                            try {
                                replacement = new ResettableNetInstance(instance);
                            }
                            catch (Impossible e) {
                                throw new RuntimeException(e);
                            }
                            copyMap.put(instance, replacement);
                        }
                        token = replacement;
                    }
                } else if (token instanceof Aggregate) {
                    token = this.replaceNetsInAggregate((Aggregate)token, copyMap, containedNetInstances);
                }
                myInst.internallyInsertTokenMultiple(token, 0.0, count, false);
            }
        }
        return containedNetInstances;
    }

    private Aggregate replaceNetsInAggregate(Aggregate aggregate, Map<NetInstance, ResettableNetInstance> copyMap, Set<NetInstance> containedNetInstances) {
        Aggregate result = aggregate;
        List<Object> javaList = null;
        if (aggregate instanceof Tuple) {
            javaList = AggregateConversionHelper.renewTupleToJavaList((Tuple)aggregate);
        } else if (aggregate instanceof de.renew.unify.List) {
            javaList = AggregateConversionHelper.renewListToJavaList((de.renew.unify.List)aggregate);
        }
        if (copyMap != null && javaList != null) {
            for (int i = 0; i < javaList.size(); ++i) {
                Object o = javaList.get(i);
                if (o instanceof NetInstance) {
                    NetInstance instance = (NetInstance)o;
                    containedNetInstances.add(instance);
                    ResettableNetInstance replacement = copyMap.get(instance);
                    if (replacement == null) {
                        try {
                            replacement = new ResettableNetInstance(instance);
                        }
                        catch (Impossible e) {
                            throw new RuntimeException(e);
                        }
                        copyMap.put(instance, replacement);
                    }
                    javaList.set(i, (Object)replacement);
                    continue;
                }
                if (!(o instanceof Aggregate)) continue;
                Aggregate replacement = this.replaceNetsInAggregate((Aggregate)o, copyMap, containedNetInstances);
                javaList.set(i, replacement);
            }
        }
        if (aggregate instanceof Tuple) {
            result = AggregateConversionHelper.javaListToRenewTuple(javaList);
        } else if (aggregate instanceof de.renew.unify.List) {
            result = AggregateConversionHelper.javaListToRenewList(javaList);
        }
        return result;
    }

    public int stateHashCode() {
        return this.stateHashCode(4);
    }

    private int stateHashCode(int depth) {
        int h = 0;
        for (Place place : this.getNet().places()) {
            h += this.getPlaceHash(place, depth);
        }
        return h;
    }

    private int getPlaceHash(Place place, int depth) {
        int h = 0;
        PlaceInstance inst = this.getInstance(place);
        for (Object token : inst.getDistinctTokens()) {
            int tokenHash;
            if (token instanceof Aggregate) {
                tokenHash = this.getAggregateHash((Aggregate)token, depth);
            } else if (!(token instanceof NetInstance)) {
                tokenHash = token.hashCode();
            } else if (token == this) {
                tokenHash = -42;
            } else if (depth > 0) {
                if (!(token instanceof ResettableNetInstance)) {
                    throw new ClassCastException(String.valueOf(token) + " should have been a " + ResettableNetInstance.class.getName() + " object");
                }
                tokenHash = ((ResettableNetInstance)((Object)token)).stateHashCode(depth - 1);
            } else {
                tokenHash = 0;
            }
            h += tokenHash ^ inst.getTokenCount(token);
        }
        return h ^ place.hashCode();
    }

    private int getAggregateHash(Aggregate aggregate, int depth) {
        int tokenHash;
        if (aggregate instanceof Tuple) {
            Tuple tuple = (Tuple)aggregate;
            tokenHash = tuple.length() + 71;
            for (int i = 0; i < tuple.length(); ++i) {
                Object component = tuple.getComponent(i);
                int componentResult = component == null ? 1 : (component instanceof ResettableNetInstance ? ((ResettableNetInstance)((Object)component)).stateHashCode(depth - 1) : (component instanceof Aggregate ? this.getAggregateHash((Aggregate)component, depth) : component.hashCode()));
                tokenHash += 41 * componentResult;
            }
        } else if (aggregate instanceof de.renew.unify.List) {
            de.renew.unify.List list = (de.renew.unify.List)aggregate;
            tokenHash = 73;
            List<Object> javaList = AggregateConversionHelper.renewListToJavaList(list);
            for (int i = javaList.size() - 1; i >= 0; --i) {
                Object component = javaList.get(i);
                int componentResult = component == null ? 1 : (component instanceof ResettableNetInstance ? ((ResettableNetInstance)((Object)component)).stateHashCode(depth - 1) : (component instanceof Aggregate ? this.getAggregateHash((Aggregate)component, depth) : component.hashCode()));
                tokenHash = componentResult + tokenHash * 43;
            }
        } else {
            tokenHash = aggregate.hashCode();
        }
        return tokenHash;
    }

    public boolean stateEquals(Object obj, Map<Object, Object> equalityMap) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetInstance)) {
            return false;
        }
        if (!(obj instanceof ResettableNetInstance)) {
            throw new RuntimeException("A " + ResettableNetInstance.class.getSimpleName() + " object was compared with a " + NetInstance.class.getSimpleName() + " object that is not a " + ResettableNetInstance.class.getSimpleName() + ".");
        }
        ResettableNetInstance other = (ResettableNetInstance)((Object)obj);
        if (this.getNet() != other.getNet()) {
            return false;
        }
        Set places = (Set)this.getNet().places();
        for (Place place : places) {
            if (this.placesNormalTokensEqual((NetInstance)other, place)) continue;
            return false;
        }
        equalityMap.put((Object)this, (Object)other);
        if (!this.containedNetInstanceTokensEqual((NetInstance)other, places, equalityMap)) {
            equalityMap.remove((Object)this);
            return false;
        }
        return true;
    }

    private boolean placesNormalTokensEqual(NetInstance other, Place place) {
        PlaceInstance myPlace = this.getInstance(place);
        PlaceInstance otherPlace = other.getInstance(place);
        Set myTokens = myPlace.getDistinctTokens();
        Set otherTokens = otherPlace.getDistinctTokens();
        if (myTokens.size() != otherTokens.size()) {
            return false;
        }
        for (Object myToken : myTokens) {
            if (myToken instanceof NetInstance || myToken instanceof Aggregate || myPlace.getTokenCount(myToken) == otherPlace.getTokenCount(myToken)) continue;
            return false;
        }
        return true;
    }

    private boolean containedNetInstanceTokensEqual(NetInstance other, Set<Place> places, Map<Object, Object> equalityMap) {
        if (!places.isEmpty()) {
            HashSet<Place> nextPlaces = new HashSet<Place>(places);
            Place place = (Place)nextPlaces.iterator().next();
            nextPlaces.remove(place);
            PlaceInstance myPlace = this.getInstance(place);
            PlaceInstance otherPlace = other.getInstance(place);
            Set myTokens = myPlace.getDistinctTokens();
            Set otherTokens = otherPlace.getDistinctTokens();
            return this.placesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces);
        }
        return true;
    }

    private boolean placesNetInstanceTokensEqual(NetInstance other, PlaceInstance myPlace, PlaceInstance otherPlace, Set<Object> myTokens, Set<Object> otherTokens, Map<Object, Object> equalityMap, Set<Place> nextPlaces) {
        HashSet<Object> nextTokens = new HashSet<Object>(myTokens);
        while (!nextTokens.isEmpty()) {
            int myTokenCount;
            Object token = nextTokens.iterator().next();
            nextTokens.remove(token);
            if (token instanceof ResettableNetInstance) {
                myTokenCount = myPlace.getTokenCount(token);
                ResettableNetInstance netInst = (ResettableNetInstance)((Object)token);
                ResettableNetInstance otherNetInst = (ResettableNetInstance)((Object)equalityMap.get(token));
                if (otherNetInst != null) {
                    if (myTokenCount == otherPlace.getTokenCount((Object)otherNetInst)) continue;
                    return false;
                }
                for (Object otherToken : otherTokens) {
                    if (!(otherToken instanceof NetInstance) || equalityMap.containsValue(otherToken) || myTokenCount != otherPlace.getTokenCount(otherToken) || !netInst.stateEquals(otherToken, equalityMap)) continue;
                    if (this.placesNetInstanceTokensEqual(other, myPlace, otherPlace, nextTokens, otherTokens, equalityMap, nextPlaces)) {
                        return true;
                    }
                    equalityMap.remove((Object)netInst);
                }
                return false;
            }
            if (token instanceof Aggregate) {
                myTokenCount = myPlace.getTokenCount(token);
                Aggregate myAggregate = (Aggregate)token;
                Aggregate otherAggregate = (Aggregate)equalityMap.get(token);
                if (otherAggregate != null) {
                    if (myTokenCount == otherPlace.getTokenCount((Object)otherAggregate)) continue;
                    return false;
                }
                for (Object otherToken : otherTokens) {
                    if (!(otherToken instanceof Aggregate) || equalityMap.containsValue(otherToken) || myTokenCount != otherPlace.getTokenCount(otherToken)) continue;
                    otherAggregate = (Aggregate)otherToken;
                    if (myAggregate.length() != otherAggregate.length()) continue;
                    ArrayDeque<Iterator<Object>> myIteratorStack = new ArrayDeque<Iterator<Object>>();
                    myIteratorStack.push(myAggregate.iterator());
                    ArrayDeque<Iterator<Object>> otherIteratorStack = new ArrayDeque<Iterator<Object>>();
                    otherIteratorStack.push(otherAggregate.iterator());
                    equalityMap.put(myAggregate, otherAggregate);
                    if (this.aggregatesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces, myIteratorStack, otherIteratorStack)) {
                        return true;
                    }
                    equalityMap.remove(myAggregate);
                }
                return false;
            }
            if (!(token instanceof NetInstance)) continue;
            throw new RuntimeException("A " + ResettableNetInstance.class.getSimpleName() + " object may not contain " + NetInstance.class.getSimpleName() + " tokens.");
        }
        return this.containedNetInstanceTokensEqual(other, nextPlaces, equalityMap);
    }

    private boolean aggregatesNetInstanceTokensEqual(NetInstance other, PlaceInstance myPlace, PlaceInstance otherPlace, Set<Object> myTokens, Set<Object> otherTokens, Map<Object, Object> equalityMap, Set<Place> nextPlaces, Deque<Iterator<Object>> myIteratorStack, Deque<Iterator<Object>> otherIteratorStack) {
        Iterator<Object> myAggregateIter = myIteratorStack.peek();
        Iterator<Object> otherAggregateIter = otherIteratorStack.peek();
        if (myAggregateIter.hasNext() && otherAggregateIter.hasNext()) {
            boolean componentsEqual;
            Object myContent = myAggregateIter.next();
            Object otherContent = otherAggregateIter.next();
            if (myContent instanceof ResettableNetInstance && otherContent instanceof ResettableNetInstance && ((NetInstance)myContent).getNet().equals(((NetInstance)otherContent).getNet())) {
                ResettableNetInstance myInst = (ResettableNetInstance)((Object)myContent);
                ResettableNetInstance otherInst = (ResettableNetInstance)((Object)otherContent);
                componentsEqual = myInst.stateEquals((Object)otherInst, equalityMap);
            } else if (myContent instanceof Aggregate && otherContent instanceof Aggregate) {
                Aggregate mySubAggregate = (Aggregate)myContent;
                Aggregate otherSubAggregate = (Aggregate)otherContent;
                if (mySubAggregate.length() == otherSubAggregate.length()) {
                    Object matchingSubAggregate = equalityMap.get(mySubAggregate);
                    if (matchingSubAggregate != null) {
                        componentsEqual = otherSubAggregate.equals(matchingSubAggregate);
                    } else {
                        myIteratorStack.push(mySubAggregate.iterator());
                        otherIteratorStack.push(otherSubAggregate.iterator());
                        equalityMap.put(mySubAggregate, otherSubAggregate);
                        componentsEqual = this.aggregatesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces, myIteratorStack, otherIteratorStack);
                    }
                } else {
                    componentsEqual = false;
                }
            } else {
                componentsEqual = myContent.equals(otherContent);
            }
            if (componentsEqual && (myIteratorStack.isEmpty() || this.aggregatesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces, myIteratorStack, otherIteratorStack))) {
                return true;
            }
            equalityMap.remove(myContent);
            return false;
        }
        myIteratorStack.pop();
        otherIteratorStack.pop();
        if (myIteratorStack.isEmpty()) {
            return this.placesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces);
        }
        return this.aggregatesNetInstanceTokensEqual(other, myPlace, otherPlace, myTokens, otherTokens, equalityMap, nextPlaces, myIteratorStack, otherIteratorStack);
    }
}

