/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.elements;

import de.renew.momoc.elements.NetInstanceState;
import de.renew.momoc.net.ResettableNetInstance;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.rgbase.elements.Node;
import de.renew.unify.Impossible;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class NodeImpl
extends Node {
    private static final long serialVersionUID = 0L;
    private final NetInstanceState _rootInstanceState;
    private final Set<ResettableNetInstance> _instances;
    private final long _depth;

    public NodeImpl(Set<ResettableNetInstance> instances, NetInstanceState rootInstanceState, long depth) {
        this._rootInstanceState = rootInstanceState;
        this._instances = instances;
        this._depth = depth;
    }

    public NodeImpl(Net net) {
        this._rootInstanceState = new NetInstanceState(net);
        this._instances = Collections.singleton(this._rootInstanceState._instance);
        this._depth = 0L;
    }

    public int hashCode() {
        return this._rootInstanceState.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NodeImpl && this._rootInstanceState.equals(((NodeImpl)((Object)obj))._rootInstanceState);
    }

    public void addTo(Map<NetInstanceState, Node> nodes) {
        nodes.put(this._rootInstanceState, this);
    }

    public NodeImpl successorFromCurrentState() {
        HashMap<NetInstance, ResettableNetInstance> copyMap = new HashMap<NetInstance, ResettableNetInstance>(this._instances.size());
        for (NetInstance netInstance : this._instances) {
            try {
                copyMap.put(netInstance, new ResettableNetInstance(netInstance.getNet(), false));
            }
            catch (Impossible e) {
                throw new RuntimeException(e);
            }
        }
        NetInstance rootNetInstance = this._rootInstanceState.getNetInstance();
        HashSet<NetInstance> hashSet = new HashSet<NetInstance>();
        HashSet<NetInstance> toExplore = new HashSet<NetInstance>();
        toExplore.add(rootNetInstance);
        while (!toExplore.isEmpty()) {
            Iterator iter = toExplore.iterator();
            NetInstance exploring = (NetInstance)iter.next();
            iter.remove();
            hashSet.add(exploring);
            Set<NetInstance> newToExplore = ((ResettableNetInstance)((Object)copyMap.get(exploring))).setTo(exploring, copyMap);
            newToExplore.removeAll(hashSet);
            toExplore.addAll(newToExplore);
        }
        NetInstanceState newRootNetState = new NetInstanceState((ResettableNetInstance)((Object)copyMap.get(rootNetInstance)));
        HashSet<ResettableNetInstance> newInstances = new HashSet<ResettableNetInstance>(hashSet.size());
        for (NetInstance exp : hashSet) {
            newInstances.add((ResettableNetInstance)((Object)copyMap.get(exp)));
        }
        return new NodeImpl(newInstances, newRootNetState, this._depth + 1L);
    }

    public Map<NetInstance, ResettableNetInstance> createBackup() {
        HashMap<NetInstance, ResettableNetInstance> backup = new HashMap<NetInstance, ResettableNetInstance>(this._instances.size());
        for (ResettableNetInstance instance : this._instances) {
            backup.put((NetInstance)instance, instance.copy());
        }
        return backup;
    }

    public void resetToBackup(Map<NetInstance, ResettableNetInstance> backup) {
        for (ResettableNetInstance instance : this._instances) {
            instance.setTo((NetInstance)backup.get((Object)instance));
        }
    }

    public Collection<? extends NetInstance> getNetInstances() {
        return this._instances;
    }

    public NetInstance getRootNetInstance() {
        return this._rootInstanceState.getNetInstance();
    }

    @Generated
    public NetInstanceState getRootInstanceState() {
        return this._rootInstanceState;
    }

    @Generated
    public long getDepth() {
        return this._depth;
    }
}

