/*
 * Decompiled with CFR 0.152.
 */
package de.renew.momoc.core;

import de.renew.engine.searcher.Finder;
import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.simulator.Binding;
import de.renew.momoc.core.BindingContainer;
import de.renew.momoc.core.GraphFinder;
import de.renew.momoc.elements.NodeImpl;
import de.renew.momoc.net.ResettableNetInstance;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.rgbase.elements.Edge;
import de.renew.rgbase.elements.InscribedEdge;
import de.renew.rgbase.elements.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;

public class BindingCore {
    private static final Logger log = Logger.getLogger(BindingCore.class);
    GraphFinder.TransitionChecker _checker;

    public BindingCore(GraphFinder.TransitionChecker checker) {
        this._checker = checker;
    }

    public Collection<BindingContainer> getBindings(Node node) {
        ArrayList<BindingContainer> bindings = new ArrayList<BindingContainer>();
        for (NetInstance instance : node.getNetInstances()) {
            for (Transition transition : instance.getNet().transitions()) {
                String name = instance == node.getRootNetInstance() ? transition.toString() : instance.getInstance(transition).toString();
                GraphFinder finder = new GraphFinder(this._checker);
                new Searcher().searchAndRecover((Finder)finder, (Searchable)instance.getInstance(transition), null);
                for (Binding binding : finder.unexplorableBindings()) {
                    String description = binding.getDescription();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("not exploring: " + description));
                    }
                    node.addEdge((Edge)new InscribedEdge(name, description, null));
                }
                for (Binding binding : finder.explorableBindings()) {
                    bindings.add(new BindingContainer(binding, name));
                }
            }
        }
        return bindings;
    }

    public Collection<BindingContainer> getBindingsWithCustomTransitionChecker(Node node, GraphFinder.TransitionChecker transitionChecker) {
        GraphFinder.TransitionChecker original = this._checker;
        this._checker = transitionChecker;
        Collection<BindingContainer> bindings = this.getBindings(node);
        this._checker = original;
        return bindings;
    }

    public Collection<BindingContainer> executeMultipleBindings(NodeImpl node, Collection<BindingContainer> bindings) {
        Map<NetInstance, ResettableNetInstance> backup = node.createBackup();
        for (BindingContainer bindingContainer : bindings) {
            this.executeBinding(node, bindingContainer, backup);
        }
        return bindings;
    }

    public void executeBinding(NodeImpl node, BindingContainer bindingContainer, Map<NetInstance, ResettableNetInstance> backup) {
        bindingContainer.getBinding().execute(null, false);
        NodeImpl successor = node.successorFromCurrentState();
        bindingContainer.setResultingNode(successor);
        node.resetToBackup(backup);
    }

    public void executeBinding(NodeImpl node, BindingContainer binding) {
        this.executeBinding(node, binding, node.createBackup());
    }
}

