/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScreenDockProperty
extends AbstractDockableProperty {
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean fullscreen;
    private Path placeholder;

    public String getFactoryID() {
        return "screen dock";
    }

    public ScreenDockProperty() {
    }

    public ScreenDockProperty(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public ScreenDockProperty(int x, int y, int width, int height, Path placeholder) {
        this(x, y, width, height, placeholder, false);
    }

    public ScreenDockProperty(int x, int y, int width, int height, Path placeholder, boolean fullscreen) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.placeholder = placeholder;
        this.fullscreen = fullscreen;
    }

    public ScreenDockProperty copy() {
        ScreenDockProperty copy = new ScreenDockProperty(this.x, this.y, this.width, this.height, this.placeholder, this.fullscreen);
        this.copy(copy);
        return copy;
    }

    public void store(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeBoolean(this.fullscreen);
        out.writeBoolean(this.placeholder != null);
        if (this.placeholder != null) {
            out.writeUTF(this.placeholder.toString());
        }
    }

    public void store(XElement element) {
        element.addElement("x").setInt(this.x);
        element.addElement("y").setInt(this.y);
        element.addElement("width").setInt(this.width);
        element.addElement("height").setInt(this.height);
        element.addElement("fullscreen").setBoolean(this.fullscreen);
        if (this.placeholder != null) {
            element.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    public void load(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        this.x = in.readInt();
        this.y = in.readInt();
        this.width = in.readInt();
        this.height = in.readInt();
        this.fullscreen = false;
        this.placeholder = null;
        if (version.compareTo(Version.VERSION_1_0_8) >= 0) {
            this.fullscreen = in.readBoolean();
            if (in.readBoolean()) {
                this.placeholder = new Path(in.readUTF());
            }
        }
    }

    public void load(XElement element) {
        XElement xplaceholder;
        this.x = element.getElement("x").getInt();
        this.y = element.getElement("y").getInt();
        this.width = element.getElement("width").getInt();
        this.height = element.getElement("height").getInt();
        this.fullscreen = false;
        this.placeholder = null;
        XElement xfullscreen = element.getElement("fullscreen");
        if (xfullscreen != null) {
            this.fullscreen = xfullscreen.getBoolean();
        }
        if ((xplaceholder = element.getElement("placeholder")) != null) {
            this.placeholder = new Path(xplaceholder.getString());
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public void setFullscreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
    }

    public void setPlaceholder(Path placeholder) {
        this.placeholder = placeholder;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fullscreen ? 1231 : 1237);
        result = 31 * result + this.height;
        result = 31 * result + (this.placeholder == null ? 0 : this.placeholder.hashCode());
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScreenDockProperty other = (ScreenDockProperty)obj;
        if (this.fullscreen != other.fullscreen) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.placeholder == null ? other.placeholder != null : !this.placeholder.equals(other.placeholder)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }
}

