package de.renew.windowmanagement;

import java.awt.Component;
import java.awt.Point;

/**
 * Interface for draggable component drop.
 * Provides a dropComponent method witch is responsible for dragging a component.
 */
public interface DraggableComponentDropTarget {
    /**
     * Drops a dragged component on a point location on the screen.
     *
     * @param draggedComponent the component that has to be dropped.
     * @param locationOnScreen the point where you want to drop the component.
     */
    void dropComponent(Component draggedComponent, Point locationOnScreen);
}