package de.renew.windowmanagement;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 *  The responsible class for the canvas to be draggable.
 *  And the shadow display of the different panels.
 */
public abstract class DragCanvas extends JScrollPane implements DraggableComponentDropTarget {
    /**
     * The Position where the shadow is displayed.
     */
    Point _shadowPosition;
    /**
     * The Image of the shadow.
     */
    Image _shadow;

    /**
     * Set horizontal and vertical scrollbar to a panel.
     *
     * @param panel the panel where you want to add it to.
     */
    public DragCanvas(JPanel panel) {
        super(panel);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);

        if (_shadowPosition != null) {
            g.drawImage(_shadow, _shadowPosition.x, _shadowPosition.y, null);
        }
    }

    /**
     * Request a shadow of a dragged component being drawn at the specified position.
     * @param absolutePosition is the position where the shadow should be
     * @param image is the image to be shadowed
     */
    public void requestOverlayingShadow(Point absolutePosition, Image image) {
        if (absolutePosition != null && image != null) {
            Point thisLocation = this.getLocationOnScreen();
            _shadowPosition =
                new Point(absolutePosition.x - thisLocation.x, absolutePosition.y - thisLocation.y);
            _shadow = image;
        } else {
            _shadowPosition = null;
            _shadow = null;
        }
    }

    @Override
    public void dropComponent(Component draggedComponent, Point locationOnScreen) {}
}