package de.renew.tablet;

import java.awt.event.KeyEvent;
import java.net.URL;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.MenuManager;
import CH.ifa.draw.application.VersionInfoCommand;
import CH.ifa.draw.util.CommandMenu;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;
import de.renew.tablet.commands.ShowPaletteCommand;


/**
 * This is a generated file. Generated by PluginDevelopment
 * plugin (version ${pd.version})
 * Representative for the Tablet plug-in.
 *
 * @author PluginGenerator
 * @author Lawrence Cabac
 */
public class TabletPlugin extends PluginAdapter {
    private boolean _loaded = false;
    private PaletteCreator _pc;
    private CommandMenu _menu;
    private static final String IMAGES = "/de/renew/diagram/images/";

    /** Initialize the plugin, register menus and commands.
     * {@link de.renew.plugin.PluginAdapter#init()}
     */
    @Override
    public void init() {
        _menu = createMenu();
        MenuManager.getInstance().registerMenu(DrawPlugin.TOOLS_MENU, _menu);
    }

    /** Deinitialize plugin.
     * {@link de.renew.plugin.PluginAdapter#cleanup()}
     */
    @Override
    public boolean cleanup() {
        MenuManager.getInstance().unregisterMenu(_menu);
        _menu = null;
        return super.cleanup();
    }

    /**
     * Creates an instance of the TabletPlugin using the contents of <code>plugin.cfg</code>.
     *
     * @param url  pointing to the <code>jar</code>
     *             file or directory containing the plugin code and configuration files.
     * @throws PluginException if an error occurs while loading the plugin or its configuration.
     */
    public TabletPlugin(URL url) throws PluginException {
        super(url);
    }

    /**
     * Creates an instance of the TabletPlugin with the given PluginProperties.
     *
     * @param props the given properties
     */
    public TabletPlugin(PluginProperties props) {
        super(props);
    }

    /**
    * Creates a new default palette and refreshes the menuFrame, if not already loaded.
    * If loaded the palette gets removed.
    */
    public void create() {
        // toggel on/off
        if (_loaded) {
            _pc.remove();
            _loaded = false;
        } else {
            _pc = new PaletteCreator("tabletPalette");
            _loaded = true;
        }
    }

    /**
     * Creates a new CommandMenu with the ShowPaletteCommand and the VersionInfoCommand.
     * @return the created CommandMenu
     */
    private CommandMenu createMenu() {
        CommandMenu menu = new CommandMenu("Tablet");
        menu.add(new ShowPaletteCommand(this), KeyEvent.VK_5);
        menu.addSeparator();
        menu.add(new VersionInfoCommand(this));
        menu.putClientProperty(MenuManager.ID_PROPERTY, "de.renew.gui.tablet");

        return menu;
    }
}
