package de.renew.splashscreen;

import java.beans.PropertyChangeEvent;

import org.assertj.swing.edt.FailOnThreadViolationRepaintManager;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.fixture.FrameFixture;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.assertj.swing.fixture.Containers.showInFrame;

@ExtendWith(MockitoExtension.class)
public class ExtendedProgressBarTest {
    ExtendedProgressBar _extendedProgressBar;
    FrameFixture _frameFixture;
    @Mock
    PropertyChangeEvent _propertyChangeEvent;

    /**
     * Installs a {@link FailOnThreadViolationRepaintManager} to catch violations of Swing threading rules.
     */
    @BeforeAll
    public static void setUpOnce() {
        FailOnThreadViolationRepaintManager.install();
    }

    /**
     * This method is automatically executed before each test method
     */
    @BeforeEach
    public void setUp() {
        // Uses the GuiActionRunner to create an Instance of ExtendedProgressBar
        _extendedProgressBar = GuiActionRunner.execute(ExtendedProgressBar::getInstance);
        // Creates a new JFrame and uses the extendedProgressBAr as its content pane.
        _frameFixture = showInFrame(_extendedProgressBar);
        // Configures the mock object propertyChangeEvent
        Mockito.when(_propertyChangeEvent.getPropertyName()).thenReturn("progress");
        Mockito.when(_propertyChangeEvent.getNewValue()).thenReturn(90);
    }

    /**
     * Tests the method propertyChange
     */
    @Test
    public void testPropertyChangeProgress() {
        //Asserts that the ProgressBarr has the value 0
        _frameFixture.progressBar().requireValue(0);
        //Uses the GuiActionRunner to execute the method propertyChange
        GuiActionRunner.execute(() -> _extendedProgressBar.propertyChange(_propertyChangeEvent));
        //Asserts that the ProgressBarr has the value 90
        _frameFixture.progressBar().requireValue(90);
    }

    /**
     * This method is automatically executed after each test method
     */
    @AfterEach
    public void tearDown() {
        _frameFixture.cleanUp();
    }
}