package de.renew.unify;

class RecorderChecker {
    private boolean _recorderUsed;

    RecorderChecker(StateRecorder recorder) {
        _recorderUsed = (recorder != null);
    }

    void checkRecorder(StateRecorder recorder) {
        if (recorder == null) {
            if (_recorderUsed) {
                throw new RuntimeException("Permanent action after undoable action. Strange.");
            }
        } else {
            // It would be possible to record the original
            // value in the state recorder. That way we could
            // unify undoable, undo, and then unify permanently.
            // But that is dangerous anyway and should be reported.
            // Hence, we are conservative.
            _recorderUsed = true;
        }
    }
}